/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#ifndef GEODE_NATIVE_GLOBALS_H_
#define GEODE_NATIVE_GLOBALS_H_

#ifdef _MSC_VER
// disable: "C++ Exception Specification ignored"
// This is because MSVC did not implement all the C++ exception
// specifications in the ANSI C++ draft.
#pragma warning(disable : 4290)
// Turn off warnings generated by lengthy std templates
// This warns about truncation to 255 characters in debug/browse info
#pragma warning(disable : 4786)
// disable: "<type> needs to have dll-interface to be used by clients'
// Happens on STL member variables which are not public therefore is ok
#pragma warning(disable : 4251)
#endif

#ifndef __has_cpp_attribute
#define __has_cpp_attribute(x) 0
#endif

#if __cplusplus >= 201402L
#if __has_cpp_attribute(deprecated)
// C++14 standard deprecated attribute
#define _GEODE_DEPRECATED_(msg) [[deprecated(msg)]]
#else
#error "__has_cpp_attribute(deprecated)"
#endif
#elif defined(__GNUC__)
// GCC style deprecated attribute
#define _GEODE_DEPRECATED_(msg) __attribute__((deprecated(msg)))
#elif defined(_MSC_VER)
// Visual C++ style deprecated attribute
#define _GEODE_DEPRECATED_(msg) __declspec(deprecated(msg))
#else
#define _GEODE_DEPRECATED_(msg)
#endif

#include "geode_base.hpp"

#endif  // GEODE_NATIVE_GLOBALS_H_
