/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.EntityCreationException;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.model.AbstractClassMapping;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public abstract class AbstractPersistentEntity<T extends Entity>
implements PersistentEntity {
    protected final Class javaClass;
    protected final MappingContext context;
    protected List<PersistentProperty> persistentProperties;
    protected List<Association> associations;
    protected List<Embedded> embedded;
    protected Map<String, PersistentProperty> propertiesByName = new HashMap<String, PersistentProperty>();
    protected Map<String, PersistentProperty> mappedPropertiesByName = new HashMap<String, PersistentProperty>();
    protected PersistentProperty identity;
    protected PersistentProperty version;
    protected List<String> persistentPropertyNames;
    private final String decapitalizedName;
    protected Set owners;
    private PersistentEntity parentEntity;
    private boolean external;
    private boolean initialized = false;
    private boolean propertiesInitialized = false;
    private boolean versionCompatibleType;
    private boolean versioned = true;
    private PersistentProperty[] compositeIdentity;
    private final String mappingStrategy;
    private final boolean isAbstract;
    private EntityReflector entityReflector;
    private final boolean isMultiTenant;
    private TenantId tenantId;

    public AbstractPersistentEntity(Class javaClass, MappingContext context) {
        Assert.notNull((Object)javaClass, "The argument [javaClass] cannot be null");
        this.javaClass = javaClass;
        this.context = context;
        this.isAbstract = Modifier.isAbstract(javaClass.getModifiers());
        this.isMultiTenant = ClassUtils.isMultiTenant(javaClass);
        this.decapitalizedName = Introspector.decapitalize(javaClass.getSimpleName());
        String classSpecified = ClassPropertyFetcher.getStaticPropertyValue(javaClass, "mapWith", String.class);
        this.mappingStrategy = classSpecified != null ? classSpecified : "GORM";
    }

    @Override
    public PersistentProperty[] getCompositeIdentity() {
        return this.compositeIdentity;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public void setExternal(boolean external) {
        this.external = external;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.context;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize() {
        ClassMapping<T> mapping = this.getMapping();
        if (!this.initialized) {
            IdentityMapping identifier;
            PersistentProperty v;
            this.initialized = true;
            MappingConfigurationStrategy mappingSyntaxStrategy = this.context.getMappingSyntaxStrategy();
            this.owners = mappingSyntaxStrategy.getOwningEntities(this.javaClass, this.context);
            Class superClass = this.javaClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && mappingSyntaxStrategy.isPersistentEntity(superClass)) {
                this.parentEntity = this.context.addPersistentEntity(superClass);
            }
            this.persistentProperties = mappingSyntaxStrategy.getPersistentProperties(this, this.context, mapping, this.includeIdentifiers());
            this.persistentPropertyNames = new ArrayList<String>();
            this.associations = new ArrayList<Association>();
            this.embedded = new ArrayList<Embedded>();
            boolean multiTenancyEnabled = this.isMultiTenant && this.context.getMultiTenancyMode() == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR;
            for (PersistentProperty persistentProperty : this.persistentProperties) {
                if (multiTenancyEnabled && persistentProperty instanceof TenantId) {
                    this.tenantId = (TenantId)persistentProperty;
                }
                if (persistentProperty instanceof Identity) {
                    if (this.compositeIdentity != null) {
                        int l = this.compositeIdentity.length;
                        this.compositeIdentity = Arrays.copyOf(this.compositeIdentity, l + 1);
                        this.compositeIdentity[l] = this.identity;
                    } else if (this.identity != null) {
                        this.compositeIdentity = new PersistentProperty[]{this.identity, persistentProperty};
                        this.identity = null;
                    } else {
                        this.identity = persistentProperty;
                    }
                }
                if (!(persistentProperty instanceof OneToMany)) {
                    this.persistentPropertyNames.add(persistentProperty.getName());
                }
                if (persistentProperty instanceof Association) {
                    this.associations.add((Association)persistentProperty);
                }
                if (persistentProperty instanceof Embedded) {
                    this.embedded.add((Embedded)persistentProperty);
                }
                this.propertiesByName.put(persistentProperty.getName(), persistentProperty);
                String targetName = ((Property)persistentProperty.getMapping().getMappedForm()).getTargetName();
                if (targetName == null) continue;
                this.mappedPropertiesByName.put(targetName, persistentProperty);
            }
            if (this.associations.isEmpty()) {
                this.associations = Collections.emptyList();
            }
            if (this.embedded.isEmpty()) {
                this.embedded = Collections.emptyList();
            }
            if (this.identity == null && this.compositeIdentity == null) {
                this.identity = this.resolveIdentifier();
            }
            if (multiTenancyEnabled && this.tenantId == null) {
                throw new ConfigurationException("Class [" + this.javaClass.getName() + "] is multi tenant but does not specify a tenant identifier property");
            }
            if (!this.isExternal()) {
                T mappedForm = mapping.getMappedForm();
                if (((Entity)mappedForm).isVersioned()) {
                    this.version = this.propertiesByName.get("version");
                    if (this.version == null) {
                        this.versioned = false;
                    }
                } else {
                    this.versioned = false;
                }
            }
            if ((v = this.getVersion()) != null) {
                Class<?> type = v.getType();
                boolean bl = this.versionCompatibleType = Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type);
            }
            if (this.identity != null) {
                String idName = this.identity.getName();
                PersistentProperty idProp = this.propertiesByName.get(idName);
                if (idProp == null) {
                    this.propertiesByName.put(idName, this.identity);
                } else {
                    this.persistentProperties.remove(idProp);
                    this.persistentPropertyNames.remove(idProp.getName());
                    if (!idProp.getName().equals("id")) {
                        this.disableDefaultId();
                    }
                }
            }
            IdentityMapping identityMapping = identifier = mapping != null ? mapping.getIdentifier() : null;
            if (this.identity == null && identifier != null) {
                String[] identifierName = identifier.getIdentifierName();
                MappingContext mappingContext = this.getMappingContext();
                if (identifierName.length > 1) {
                    this.compositeIdentity = mappingContext.getMappingSyntaxStrategy().getCompositeIdentity(this.javaClass, mappingContext);
                }
                for (String in : identifierName) {
                    PersistentProperty p = this.propertiesByName.get(in);
                    if (p != null) {
                        this.persistentProperties.remove(p);
                    }
                    this.persistentPropertyNames.remove(in);
                }
                this.disableDefaultId();
            }
        }
        this.propertiesInitialized = true;
        this.entityReflector = this.getMappingContext().getEntityReflector(this);
    }

    private void disableDefaultId() {
        PersistentProperty otherId = this.getPropertyByName("id");
        if (otherId != null) {
            this.persistentProperties.remove(otherId);
            this.persistentPropertyNames.remove("id");
        }
    }

    @Override
    public EntityReflector getReflector() {
        return this.entityReflector;
    }

    protected boolean isAnnotatedSuperClass(MappingConfigurationStrategy mappingSyntaxStrategy, Class superClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = superClass.getAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals("grails.persistence.Entity") && !name.equals("grails.gorm.annotation.Entity")) continue;
            return true;
        }
        return false;
    }

    protected boolean includeIdentifiers() {
        return true;
    }

    protected PersistentProperty resolveIdentifier() {
        return this.context.getMappingSyntaxStrategy().getIdentity(this.javaClass, this.context);
    }

    @Override
    public boolean hasProperty(String name, Class type) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.getJavaClass(), name);
        return pd != null && pd.getPropertyType().equals(type);
    }

    @Override
    public boolean isIdentityName(String propertyName) {
        return this.getIdentity().getName().equals(propertyName);
    }

    @Override
    public PersistentEntity getParentEntity() {
        return this.parentEntity;
    }

    @Override
    public String getDiscriminator() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public PersistentEntity getRootEntity() {
        PersistentEntity root = this;
        for (PersistentEntity parent = this.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            if (!parent.isInitialized()) {
                parent.initialize();
            }
            root = parent;
        }
        return root;
    }

    @Override
    public boolean isRoot() {
        return this.getParentEntity() == null;
    }

    @Override
    public boolean isOwningEntity(PersistentEntity owner) {
        return owner != null && this.owners.contains(owner.getJavaClass());
    }

    @Override
    public String getDecapitalizedName() {
        return this.decapitalizedName;
    }

    @Override
    public List<String> getPersistentPropertyNames() {
        return this.persistentPropertyNames;
    }

    @Override
    public ClassMapping<T> getMapping() {
        return new AbstractClassMapping<Entity>((PersistentEntity)this, this.context){

            @Override
            public Entity getMappedForm() {
                return new Entity();
            }
        };
    }

    @Override
    public Object newInstance() {
        try {
            return this.getJavaClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityCreationException("Unable to create entity of type [" + this.getJavaClass().getName() + "]: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new EntityCreationException("Unable to create entity of type [" + this.getJavaClass().getName() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.javaClass.getName();
    }

    @Override
    public PersistentProperty getIdentity() {
        return this.identity;
    }

    @Override
    public PersistentProperty getVersion() {
        return this.version;
    }

    @Override
    public boolean isVersioned() {
        return (this.versionCompatibleType || !this.propertiesInitialized) && this.versioned;
    }

    @Override
    public Class getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.getJavaClass().isInstance(obj);
    }

    @Override
    public List<PersistentProperty> getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public List<Association> getAssociations() {
        return this.associations;
    }

    @Override
    public List<Embedded> getEmbedded() {
        return this.embedded;
    }

    @Override
    public PersistentProperty getPropertyByName(String name) {
        PersistentProperty pp = this.propertiesByName.get(name);
        if (pp != null) {
            return pp;
        }
        return this.mappedPropertiesByName.get(name);
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PersistentEntity)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        PersistentEntity other = (PersistentEntity)o;
        return this.javaClass.equals(other.getJavaClass());
    }

    public String toString() {
        return this.javaClass.getName();
    }

    @Override
    public boolean addOwner(Class type) {
        return this.owners.add(type);
    }

    private static class MappingProperties {
        private Boolean version = true;
        private boolean intialized = false;

        private MappingProperties() {
        }

        public boolean isIntialized() {
            return this.intialized;
        }

        public void setIntialized(boolean intialized) {
            this.intialized = intialized;
        }

        public void setVersion(boolean version) {
            this.version = version;
        }

        public boolean isVersioned() {
            return this.version == null ? true : this.version;
        }
    }
}

