/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.math.BigInteger;
import java.util.Map;

public class BigIntFunction
extends AbstractFunction {
    private static final long serialVersionUID = 820173052464302490L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        switch (arg1.getAviatorType()) {
            case Boolean: {
                return AviatorBigInt.valueOf(arg1.booleanValue(env) ? BigInteger.ONE : BigInteger.ZERO);
            }
            case JavaType: {
                Object obj = arg1.getValue(env);
                if (obj instanceof Number) {
                    return AviatorBigInt.valueOf(new BigInteger(String.valueOf(obj)));
                }
                if (obj instanceof String) {
                    return AviatorBigInt.valueOf(new BigInteger((String)obj));
                }
                if (obj instanceof Character) {
                    return AviatorBigInt.valueOf(new BigInteger(String.valueOf(obj)));
                }
                throw new ClassCastException("Could not cast " + (obj != null ? obj.getClass().getName() : "null") + " to bigint, AviatorObject is " + arg1);
            }
            case String: {
                return AviatorBigInt.valueOf(new BigInteger((String)arg1.getValue(env)));
            }
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return AviatorBigInt.valueOf(((AviatorNumber)arg1).toBigInt());
            }
        }
        throw new ClassCastException("Could not cast " + arg1 + " to bigint");
    }

    @Override
    public String getName() {
        return "bigint";
    }
}

