/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergViewOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;

public class IcebergViewOperationExecutor
implements IcebergViewOperationDispatcher {
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;

    public IcebergViewOperationExecutor(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @Override
    public LoadViewResponse createView(IcebergRequestContext context, Namespace namespace, CreateViewRequest createViewRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).createView(namespace, createViewRequest);
    }

    @Override
    public LoadViewResponse replaceView(IcebergRequestContext context, TableIdentifier viewIdentifier, UpdateTableRequest replaceViewRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).updateView(viewIdentifier, replaceViewRequest);
    }

    @Override
    public void dropView(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).dropView(viewIdentifier);
    }

    @Override
    public LoadViewResponse loadView(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).loadView(viewIdentifier);
    }

    @Override
    public ListTablesResponse listView(IcebergRequestContext context, Namespace namespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).listView(namespace);
    }

    @Override
    public boolean viewExists(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).viewExists(viewIdentifier);
    }

    @Override
    public void renameView(IcebergRequestContext context, RenameTableRequest renameViewRequest) {
        this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).renameView(renameViewRequest);
    }
}

