/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.credentials.Credential;

public class LoadTableResponse
implements RESTResponse {
    private String metadataLocation;
    private TableMetadata metadata;
    private Map<String, String> config;
    private TableMetadata metadataWithLocation;
    private List<Credential> credentials;

    public LoadTableResponse() {
    }

    private LoadTableResponse(String metadataLocation, TableMetadata metadata, Map<String, String> config, List<Credential> credentials) {
        this.metadataLocation = metadataLocation;
        this.metadata = metadata;
        this.config = config;
        this.credentials = credentials;
    }

    @Override
    public void validate() {
        Preconditions.checkNotNull((Object)this.metadata, (Object)"Invalid metadata: null");
    }

    public String metadataLocation() {
        return this.metadataLocation;
    }

    public TableMetadata tableMetadata() {
        if (null == this.metadataWithLocation) {
            this.metadataWithLocation = TableMetadata.buildFrom(this.metadata).withMetadataLocation(this.metadataLocation).build();
        }
        return this.metadataWithLocation;
    }

    public Map<String, String> config() {
        return this.config != null ? this.config : ImmutableMap.of();
    }

    public List<Credential> credentials() {
        return this.credentials != null ? this.credentials : ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadataLocation", (Object)this.metadataLocation).add("metadata", (Object)this.metadata).add("config", this.config).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String metadataLocation;
        private TableMetadata metadata;
        private final Map<String, String> config = Maps.newHashMap();
        private final List<Credential> credentials = Lists.newArrayList();

        private Builder() {
        }

        public Builder withTableMetadata(TableMetadata tableMetadata) {
            this.metadataLocation = tableMetadata.metadataFileLocation();
            this.metadata = tableMetadata;
            return this;
        }

        public Builder addConfig(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public Builder addAllConfig(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public Builder addCredential(Credential credential) {
            this.credentials.add(credential);
            return this;
        }

        public Builder addAllCredentials(List<Credential> credentialsToAdd) {
            this.credentials.addAll(credentialsToAdd);
            return this;
        }

        public LoadTableResponse build() {
            Preconditions.checkNotNull((Object)this.metadata, (Object)"Invalid metadata: null");
            return new LoadTableResponse(this.metadataLocation, this.metadata, this.config, this.credentials);
        }
    }
}

