/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;

public class DailyRestriction {
    private final List<DayOfWeek> weekDays;
    private final LocalTime startTime;
    private final LocalTime endTime;

    public DailyRestriction(DayOfWeek weekDay, LocalTime startTime, LocalTime endTime) {
        this.weekDays = Collections.singletonList(weekDay);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public DailyRestriction(List<DayOfWeek> weekDays, LocalTime startTime, LocalTime endTime) {
        this.weekDays = weekDays;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public DailyRestriction(DayOfWeek weekDay) {
        this.weekDays = Collections.singletonList(weekDay);
        this.startTime = LocalTime.of(0, 0, 0);
        this.endTime = LocalTime.of(23, 59, 59);
    }

    public DailyRestriction(List<DayOfWeek> weekDays) {
        this.weekDays = weekDays;
        this.startTime = LocalTime.of(0, 0, 0);
        this.endTime = LocalTime.of(23, 59, 59);
    }

    public boolean appliesNow() {
        DayOfWeek currentDay = LocalDate.now(ZoneId.of("UTC")).getDayOfWeek();
        LocalTime currentTime = LocalTime.now(ZoneId.of("UTC"));
        if (this.endTime.isBefore(this.startTime)) {
            if (this.weekDays.contains(currentDay) && currentTime.isAfter(this.startTime) && currentTime.isBefore(LocalTime.MAX)) {
                return true;
            }
            return this.weekDays.contains(currentDay.plus(1L)) && currentTime.isAfter(LocalTime.MIDNIGHT) && currentTime.isBefore(this.endTime);
        }
        return this.weekDays.contains(currentDay) && currentTime.isAfter(this.startTime) && currentTime.isBefore(this.endTime);
    }
}

