/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MountVolumeInfo;

@InterfaceAudience.Private
public class MountVolumeMap {
    private final ConcurrentMap<String, MountVolumeInfo> mountVolumeMapping = new ConcurrentHashMap<String, MountVolumeInfo>();
    private final Configuration conf;

    MountVolumeMap(Configuration conf) {
        this.conf = conf;
    }

    FsVolumeReference getVolumeRefByMountAndStorageType(String mount, StorageType storageType) {
        if (this.mountVolumeMapping.containsKey(mount)) {
            return ((MountVolumeInfo)this.mountVolumeMapping.get(mount)).getVolumeRef(storageType);
        }
        return null;
    }

    double getCapacityRatioByMountAndStorageType(String mount, StorageType storageType) {
        if (this.mountVolumeMapping.containsKey(mount)) {
            return ((MountVolumeInfo)this.mountVolumeMapping.get(mount)).getCapacityRatio(storageType);
        }
        return 1.0;
    }

    void addVolume(FsVolumeImpl volume) {
        String mount = volume.getMount();
        if (!mount.isEmpty()) {
            MountVolumeInfo info;
            if (this.mountVolumeMapping.containsKey(mount)) {
                info = (MountVolumeInfo)this.mountVolumeMapping.get(mount);
            } else {
                info = new MountVolumeInfo(this.conf);
                this.mountVolumeMapping.put(mount, info);
            }
            info.addVolume(volume);
        }
    }

    void removeVolume(FsVolumeImpl target) {
        String mount = target.getMount();
        if (!mount.isEmpty()) {
            MountVolumeInfo info = (MountVolumeInfo)this.mountVolumeMapping.get(mount);
            info.removeVolume(target);
            if (info.size() == 0) {
                this.mountVolumeMapping.remove(mount);
            }
        }
    }

    void setCapacityRatio(FsVolumeImpl target, double capacityRatio) throws IOException {
        MountVolumeInfo info;
        String mount = target.getMount();
        if (!mount.isEmpty() && !(info = (MountVolumeInfo)this.mountVolumeMapping.get(mount)).setCapacityRatio(target.getStorageType(), capacityRatio)) {
            throw new IOException("Not enough capacity ratio left on mount: " + mount + ", for " + target + ": capacity ratio: " + capacityRatio + ". Sum of the capacity ratio of on same disk mount should be <= 1");
        }
    }

    public boolean hasMount(String mount) {
        return this.mountVolumeMapping.containsKey(mount);
    }
}

