/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPreemptableResourceCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPreemptableResourceCalculator.class);
    protected final CapacitySchedulerPreemptionContext context;
    protected final ResourceCalculator rc;
    protected boolean isReservedPreemptionCandidatesSelector;
    private Resource stepFactor;
    private boolean allowQueuesBalanceAfterAllQueuesSatisfied;

    public AbstractPreemptableResourceCalculator(CapacitySchedulerPreemptionContext preemptionContext, boolean isReservedPreemptionCandidatesSelector, boolean allowQueuesBalanceAfterAllQueuesSatisfied) {
        this.context = preemptionContext;
        this.rc = preemptionContext.getResourceCalculator();
        this.isReservedPreemptionCandidatesSelector = isReservedPreemptionCandidatesSelector;
        this.allowQueuesBalanceAfterAllQueuesSatisfied = allowQueuesBalanceAfterAllQueuesSatisfied;
        this.stepFactor = Resource.newInstance((int)0, (int)0);
        for (ResourceInformation ri : this.stepFactor.getResources()) {
            ri.setValue(1L);
        }
    }

    protected void computeFixpointAllocation(Resource totGuarant, Collection<TempQueuePerPartition> qAlloc, Resource unassigned, boolean ignoreGuarantee) {
        TQComparator tqComparator = new TQComparator(this.rc, totGuarant);
        PriorityQueue<TempQueuePerPartition> orderedByNeed = new PriorityQueue<TempQueuePerPartition>(10, tqComparator);
        for (TempQueuePerPartition q : qAlloc) {
            Resource used = q.getUsed();
            Resource initIdealAssigned = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)used, (Resource)q.getGuaranteed()) ? Resources.add((Resource)Resources.componentwiseMin((Resource)q.getGuaranteed(), (Resource)q.getUsed()), (Resource)q.untouchableExtra) : Resources.clone((Resource)used);
            this.initIdealAssignment(totGuarant, q, initIdealAssigned);
            Resources.subtractFrom((Resource)unassigned, (Resource)q.idealAssigned);
            Resource curPlusPend = Resources.add((Resource)q.getUsed(), (Resource)q.pending);
            if (!Resources.lessThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)q.idealAssigned, (Resource)curPlusPend)) continue;
            orderedByNeed.add(q);
        }
        while (!orderedByNeed.isEmpty() && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)unassigned, (Resource)Resources.none())) {
            this.resetCapacity(orderedByNeed, ignoreGuarantee);
            Collection<TempQueuePerPartition> underserved = this.getMostUnderservedQueues(orderedByNeed, tqComparator);
            Resource dupUnassignedForTheRound = Resources.clone((Resource)unassigned);
            Iterator<TempQueuePerPartition> i = underserved.iterator();
            while (i.hasNext() && this.rc.isAnyMajorResourceAboveZero(unassigned)) {
                Resource wQidle;
                TempQueuePerPartition sub = i.next();
                Resource wQavail = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.rc, (Resource)dupUnassignedForTheRound, (double[])sub.normalizedGuarantee, (Resource)this.stepFactor);
                Resource wQdone = Resources.subtract((Resource)(wQavail = Resources.componentwiseMin((Resource)wQavail, (Resource)unassigned)), (Resource)(wQidle = sub.offer(wQavail, this.rc, totGuarant, this.isReservedPreemptionCandidatesSelector, this.allowQueuesBalanceAfterAllQueuesSatisfied)));
                if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)wQdone, (Resource)Resources.none())) {
                    orderedByNeed.add(sub);
                }
                Resources.subtractFrom((Resource)unassigned, (Resource)wQdone);
                unassigned = Resources.componentwiseMax((Resource)unassigned, (Resource)Resources.none());
            }
        }
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
        }
    }

    protected void initIdealAssignment(Resource totGuarant, TempQueuePerPartition q, Resource initIdealAssigned) {
        q.idealAssigned = initIdealAssigned;
    }

    private void resetCapacity(Collection<TempQueuePerPartition> queues, boolean ignoreGuar) {
        Resource activeCap = Resource.newInstance((int)0, (int)0);
        float activeTotalAbsCap = 0.0f;
        int maxLength = ResourceUtils.getNumberOfCountableResourceTypes();
        if (ignoreGuar) {
            for (int i = 0; i < maxLength; ++i) {
                for (TempQueuePerPartition q : queues) {
                    AbstractPreemptableResourceCalculator.computeNormGuarEvenly(q, queues.size(), i);
                }
            }
        } else {
            for (TempQueuePerPartition q : queues) {
                Resources.addTo((Resource)activeCap, (Resource)q.getGuaranteed());
                activeTotalAbsCap += q.getAbsCapacity();
            }
            for (int i = 0; i < maxLength; ++i) {
                boolean useAbsCapBasedNorm = false;
                boolean useEvenlyDistNorm = activeTotalAbsCap == 0.0f;
                for (TempQueuePerPartition q : queues) {
                    NormalizationTuple normTuple = new NormalizationTuple(q.getGuaranteed(), activeCap);
                    long queueGuaranValue = normTuple.getNumeratorValue(i);
                    long totalActiveGuaranValue = normTuple.getDenominatorValue(i);
                    if (queueGuaranValue == 0L && q.getAbsCapacity() != 0.0f && totalActiveGuaranValue != 0L) {
                        useAbsCapBasedNorm = true;
                        break;
                    }
                    if (totalActiveGuaranValue != 0L) continue;
                    useEvenlyDistNorm = true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queue normalization strategy: absoluteCapacityBasedNormalization(" + useAbsCapBasedNorm + "), evenlyDistributedNormalization(" + useEvenlyDistNorm + "), defaultNormalization(" + (!useAbsCapBasedNorm && !useEvenlyDistNorm) + ")");
                }
                for (TempQueuePerPartition q : queues) {
                    if (useAbsCapBasedNorm) {
                        AbstractPreemptableResourceCalculator.computeNormGuarFromAbsCapacity(q, activeTotalAbsCap, i);
                        continue;
                    }
                    if (useEvenlyDistNorm) {
                        AbstractPreemptableResourceCalculator.computeNormGuarEvenly(q, queues.size(), i);
                        continue;
                    }
                    AbstractPreemptableResourceCalculator.computeDefaultNormGuar(q, activeCap, i);
                }
            }
        }
    }

    private static void computeNormGuarFromAbsCapacity(TempQueuePerPartition q, float activeTotalAbsCap, int resourceTypeIdx) {
        if (activeTotalAbsCap != 0.0f) {
            q.normalizedGuarantee[resourceTypeIdx] = q.getAbsCapacity() / activeTotalAbsCap;
        }
    }

    private static void computeNormGuarEvenly(TempQueuePerPartition q, int numOfActiveQueues, int resourceTypeIdx) {
        q.normalizedGuarantee[resourceTypeIdx] = 1.0f / (float)numOfActiveQueues;
    }

    private static void computeDefaultNormGuar(TempQueuePerPartition q, Resource activeCap, int resourceTypeIdx) {
        NormalizationTuple normTuple = new NormalizationTuple(q.getGuaranteed(), activeCap);
        q.normalizedGuarantee[resourceTypeIdx] = normTuple.getNormalizedValue(resourceTypeIdx);
    }

    private Collection<TempQueuePerPartition> getMostUnderservedQueues(PriorityQueue<TempQueuePerPartition> orderedByNeed, TQComparator tqComparator) {
        ArrayList<TempQueuePerPartition> underserved = new ArrayList<TempQueuePerPartition>();
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            underserved.add(q1);
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
            TempQueuePerPartition q2 = orderedByNeed.peek();
            if (q2 != null && tqComparator.compare(q1, q2) >= 0) continue;
            if (null != q2) {
                this.context.addPartitionToUnderServedQueues(q2.queueName, q2.partition);
            }
            return underserved;
        }
        return underserved;
    }

    private static class NormalizationTuple {
        private Resource numerator;
        private Resource denominator;

        NormalizationTuple(Resource numer, Resource denom) {
            this.numerator = numer;
            this.denominator = denom;
        }

        long getNumeratorValue(int i) {
            return this.numerator.getResourceInformation(i).getValue();
        }

        long getDenominatorValue(int i) {
            String nUnits = this.numerator.getResourceInformation(i).getUnits();
            ResourceInformation dResourceInformation = this.denominator.getResourceInformation(i);
            return UnitsConversionUtil.convert((String)dResourceInformation.getUnits(), (String)nUnits, (long)dResourceInformation.getValue());
        }

        float getNormalizedValue(int i) {
            long nValue = this.getNumeratorValue(i);
            long dValue = this.getDenominatorValue(i);
            return dValue == 0L ? 0.0f : (float)nValue / (float)dValue;
        }
    }

    static class TQComparator
    implements Comparator<TempQueuePerPartition> {
        private ResourceCalculator rc;
        private Resource clusterRes;

        TQComparator(ResourceCalculator rc, Resource clusterRes) {
            this.rc = rc;
            this.clusterRes = clusterRes;
        }

        @Override
        public int compare(TempQueuePerPartition tq1, TempQueuePerPartition tq2) {
            double assigned1 = this.getIdealPctOfGuaranteed(tq1);
            double assigned2 = this.getIdealPctOfGuaranteed(tq2);
            return PriorityUtilizationQueueOrderingPolicy.compare(assigned1, assigned2, tq1.relativePriority, tq2.relativePriority);
        }

        private double getIdealPctOfGuaranteed(TempQueuePerPartition q) {
            double pctOver = 2.147483647E9;
            if (q != null && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.getGuaranteed(), (Resource)Resources.none())) {
                pctOver = Resources.divide((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.idealAssigned, (Resource)q.getGuaranteed());
            }
            return pctOver;
        }
    }
}

