/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.internal.Quadruple;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.time.Duration;
import rx.Single;

public interface IRetryPolicy {
    public Single<ShouldRetryResult> shouldRetry(Exception var1);

    public static class ShouldRetryResult {
        public final Duration backOffTime;
        public final Exception exception;
        public boolean shouldRetry;
        public final Quadruple<Boolean, Boolean, Duration, Integer> policyArg;

        private ShouldRetryResult(Duration dur, Exception e, boolean shouldRetry, Quadruple<Boolean, Boolean, Duration, Integer> policyArg) {
            this.backOffTime = dur;
            this.exception = e;
            this.shouldRetry = shouldRetry;
            this.policyArg = policyArg;
        }

        public static ShouldRetryResult retryAfter(Duration dur) {
            Utils.checkNotNullOrThrow((Object)dur, (String)"duration", (String)"cannot be null");
            return new ShouldRetryResult(dur, null, true, null);
        }

        public static ShouldRetryResult retryAfter(Duration dur, Quadruple<Boolean, Boolean, Duration, Integer> policyArg) {
            Utils.checkNotNullOrThrow((Object)dur, (String)"duration", (String)"cannot be null");
            return new ShouldRetryResult(dur, null, true, policyArg);
        }

        public static ShouldRetryResult error(Exception e) {
            Utils.checkNotNullOrThrow((Object)e, (String)"exception", (String)"cannot be null");
            return new ShouldRetryResult(null, e, false, null);
        }

        public static ShouldRetryResult noRetry() {
            return new ShouldRetryResult(null, null, false, null);
        }

        public void throwIfDoneTrying(Exception capturedException) throws Exception {
            if (this.shouldRetry) {
                return;
            }
            if (this.exception == null) {
                throw capturedException;
            }
            throw this.exception;
        }
    }
}

