/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import java.util.Objects;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawSingularValue;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface SingularValue<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Values<N> {
    public static final Factory<BigDecimal> BIG = typical -> new SingularValueDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new SingularValueDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (1024L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new SingularValueDecomposition.Primitive();
        }
        return new RawSingularValue();
    };

    public static <N extends Number> SingularValue<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (SingularValue)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (SingularValue)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (SingularValue)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, SingularValue<N> decomposition, NumberContext context) {
        MatrixStore<Object> tmpThat;
        MatrixStore tmpThis;
        boolean retVal;
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        MatrixStore<MatrixStore<N>> tmpQ1 = decomposition.getQ1();
        MatrixStore<N> tmpD = decomposition.getD();
        MatrixStore<Object> tmpQ2 = decomposition.getQ2();
        boolean bl = retVal = (long)tmpRowDim == tmpQ1.countRows() && tmpQ2.countRows() == (long)tmpColDim;
        if (retVal) {
            tmpThis = matrix.multiply(tmpQ2);
            tmpThat = tmpQ1.multiply(tmpD);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpQ1.countRows() == tmpQ1.countColumns()) {
            tmpThis = (MatrixStore)tmpQ1.physical().makeEye(tmpRowDim, tmpRowDim);
            tmpThat = tmpQ1.logical().conjugate().get().multiply(tmpQ1);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpQ2.countRows() == tmpQ2.countColumns()) {
            tmpThis = (MatrixStore)tmpQ2.physical().makeEye(tmpColDim, tmpColDim);
            tmpThat = tmpQ2.multiply(tmpQ2.logical().conjugate().get());
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal) {
            retVal &= matrix.equals(matrix.multiply((MatrixStore<Object>)decomposition.getInverse().multiply(matrix)), context);
        }
        if (retVal) {
            Array1D<Double> tmpSV = decomposition.getSingularValues();
            for (int i = 1; retVal && i < tmpSV.size(); retVal &= tmpSV.doubleValue(i - 1) >= tmpSV.doubleValue(i), ++i) {
            }
            if (retVal && decomposition.isOrdered()) {
                int ij = 1;
                while (retVal && (long)ij < tmpD.countRows()) {
                    retVal &= tmpD.doubleValue(ij - 1, ij - 1) >= tmpD.doubleValue(ij, ij);
                    ++ij;
                }
            }
        }
        return retVal;
    }

    public static <N extends Number> MatrixStore<N> reconstruct(SingularValue<N> decomposition) {
        return decomposition.getQ1().multiply(decomposition.getD()).multiply((MatrixStore<Object>)decomposition.getQ2().conjugate());
    }

    public double getCondition();

    public MatrixStore<N> getD();

    public double getFrobeniusNorm();

    public double getKyFanNorm(int var1);

    public double getOperatorNorm();

    public MatrixStore<N> getQ1();

    public MatrixStore<N> getQ2();

    public int getRank();

    public Array1D<Double> getSingularValues();

    default public void getSingularValues(double[] values) {
        Objects.requireNonNull(values);
        Array1D<Double> singulars = this.getSingularValues();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            values[i] = singulars.doubleValue(i);
        }
    }

    public double getTraceNorm();

    @Override
    default public MatrixStore<N> reconstruct() {
        return SingularValue.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<SingularValue<N>> {
    }
}

