/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class JobBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p().__(new Object[]{"Sorry, can't do anything without a JobID."}).__();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p().__(new Object[]{"Sorry, ", jid, " not found."}).__();
            return;
        }
        List<AMInfo> amInfos = job.getAMInfos();
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        JobInfo jinfo = new JobInfo(job, true);
        this.info("Job Overview").__("Job Name:", (Object)jinfo.getName()).__("User Name:", (Object)jinfo.getUserName()).__("Queue Name:", (Object)jinfo.getQueueName()).__("State:", (Object)jinfo.getState()).__("Uberized:", (Object)jinfo.isUberized()).__("Started:", (Object)new Date(jinfo.getStartTime())).__("Elapsed:", (Object)StringUtils.formatTime((long)jinfo.getElapsedTime()));
        Hamlet.DIV div = html.__(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#job");
        ((Hamlet.TABLE)table.tr().th(amString).__()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs").__();
        for (AMInfo amInfo : amInfos) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, jinfo.getId(), jinfo.getUserName());
            ((Hamlet.TR)((Hamlet.TR)table.tr().td(String.valueOf(attempt.getAttemptId())).td(new Date(attempt.getStartTime()).toString()).td().a(".nodelink", this.url(new String[]{MRWebAppUtil.getYARNWebappScheme(), attempt.getNodeHttpAddress()}), attempt.getNodeHttpAddress()).__()).td().a(".logslink", this.url(new String[]{attempt.getLogsLink()}), "logs").__()).__();
        }
        table.__();
        div.__();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TABLE)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Progress").th(".ui-state-default", "Total").th(".ui-state-default", "Pending").th(".ui-state-default", "Running").th(".ui-state-default", "Complete").__()).tr(".odd").th("Map").td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{jinfo.getMapProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", jinfo.getMapProgressPercent(), Character.valueOf('%')})).__()).__()).__()).td().a(this.url(new String[]{"tasks", jid, "m", "ALL"}), String.valueOf(jinfo.getMapsTotal())).__()).td().a(this.url(new String[]{"tasks", jid, "m", "PENDING"}), String.valueOf(jinfo.getMapsPending())).__()).td().a(this.url(new String[]{"tasks", jid, "m", "RUNNING"}), String.valueOf(jinfo.getMapsRunning())).__()).td().a(this.url(new String[]{"tasks", jid, "m", "COMPLETED"}), String.valueOf(jinfo.getMapsCompleted())).__()).__()).tr(".even").th("Reduce").td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{jinfo.getReduceProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", jinfo.getReduceProgressPercent(), Character.valueOf('%')})).__()).__()).__()).td().a(this.url(new String[]{"tasks", jid, "r", "ALL"}), String.valueOf(jinfo.getReducesTotal())).__()).td().a(this.url(new String[]{"tasks", jid, "r", "PENDING"}), String.valueOf(jinfo.getReducesPending())).__()).td().a(this.url(new String[]{"tasks", jid, "r", "RUNNING"}), String.valueOf(jinfo.getReducesRunning())).__()).td().a(this.url(new String[]{"tasks", jid, "r", "COMPLETED"}), String.valueOf(jinfo.getReducesCompleted())).__()).__()).__()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "New").th(".ui-state-default", "Running").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful").__()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(jinfo.getNewMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(jinfo.getRunningMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(jinfo.getFailedMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(jinfo.getKilledMapAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(jinfo.getSuccessfulMapAttempts())).__()).__()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(jinfo.getNewReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(jinfo.getRunningReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(jinfo.getFailedReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(jinfo.getKilledReduceAttempts())).__()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(jinfo.getSuccessfulReduceAttempts())).__()).__()).__()).__();
    }
}

