/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.translator;

import csi.v0.Csi;
import java.util.ArrayList;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.csi.translator.ProtoTranslator;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class ValidateVolumeCapabilitiesRequestProtoTranslator<A, B>
implements ProtoTranslator<ValidateVolumeCapabilitiesRequest, Csi.ValidateVolumeCapabilitiesRequest> {
    @Override
    public Csi.ValidateVolumeCapabilitiesRequest convertTo(ValidateVolumeCapabilitiesRequest request) throws YarnException {
        Csi.ValidateVolumeCapabilitiesRequest.Builder buidler = Csi.ValidateVolumeCapabilitiesRequest.newBuilder();
        buidler.setVolumeId(request.getVolumeId());
        if (request.getVolumeCapabilities() != null && request.getVolumeCapabilities().size() > 0) {
            buidler.putAllVolumeAttributes(request.getVolumeAttributes());
        }
        for (ValidateVolumeCapabilitiesRequest.VolumeCapability cap : request.getVolumeCapabilities()) {
            Csi.VolumeCapability.AccessMode accessMode = Csi.VolumeCapability.AccessMode.newBuilder().setModeValue(cap.getAccessMode().ordinal()).build();
            Csi.VolumeCapability.MountVolume mountVolume = Csi.VolumeCapability.MountVolume.newBuilder().addAllMountFlags(cap.getMountFlags()).build();
            Csi.VolumeCapability capability = Csi.VolumeCapability.newBuilder().setAccessMode(accessMode).setMount(mountVolume).build();
            buidler.addVolumeCapabilities(capability);
        }
        return buidler.build();
    }

    @Override
    public ValidateVolumeCapabilitiesRequest convertFrom(Csi.ValidateVolumeCapabilitiesRequest request) throws YarnException {
        ValidateVolumeCapabilitiesRequest result = ValidateVolumeCapabilitiesRequest.newInstance((String)request.getVolumeId(), request.getVolumeAttributesMap());
        for (Csi.VolumeCapability csiCap : request.getVolumeCapabilitiesList()) {
            ValidateVolumeCapabilitiesRequest.AccessMode mode = ValidateVolumeCapabilitiesRequest.AccessMode.valueOf((String)csiCap.getAccessMode().getMode().name());
            if (!csiCap.hasMount()) {
                throw new YarnException("Invalid request, mount is not found in the request.");
            }
            ArrayList<String> mountFlags = new ArrayList<String>();
            for (int i = 0; i < csiCap.getMount().getMountFlagsCount(); ++i) {
                mountFlags.add(csiCap.getMount().getMountFlags(i));
            }
            ValidateVolumeCapabilitiesRequest.VolumeCapability capability = new ValidateVolumeCapabilitiesRequest.VolumeCapability(mode, ValidateVolumeCapabilitiesRequest.VolumeType.FILE_SYSTEM, mountFlags);
            result.addVolumeCapability(capability);
        }
        return result;
    }
}

