/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.netty.channel.group.ChannelGroup;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.util.Shell;

public class ShuffleChannelHandlerContext {
    public final Configuration conf;
    public final JobTokenSecretManager secretManager;
    public final Map<String, String> userRsrc;
    public final LoadingCache<ShuffleHandler.AttemptPathIdentifier, ShuffleHandler.AttemptPathInfo> pathCache;
    public final IndexCache indexCache;
    public final ShuffleHandler.ShuffleMetrics metrics;
    public final ChannelGroup allChannels;
    public final boolean connectionKeepAliveEnabled;
    public final int sslFileBufferSize;
    public final int connectionKeepAliveTimeOut;
    public final int mapOutputMetaInfoCacheSize;
    public final AtomicInteger activeConnections = new AtomicInteger();
    public final boolean manageOsCache;
    public final int readaheadLength;
    public final int maxShuffleConnections;
    public final int shuffleBufferSize;
    public final boolean shuffleTransferToAllowed;
    public final int maxSessionOpenFiles;
    public final ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    public int port = -1;

    public ShuffleChannelHandlerContext(Configuration conf, Map<String, String> userRsrc, JobTokenSecretManager secretManager, LoadingCache<ShuffleHandler.AttemptPathIdentifier, ShuffleHandler.AttemptPathInfo> patCache, IndexCache indexCache, ShuffleHandler.ShuffleMetrics metrics, ChannelGroup allChannels) {
        this.conf = conf;
        this.userRsrc = userRsrc;
        this.secretManager = secretManager;
        this.pathCache = patCache;
        this.indexCache = indexCache;
        this.metrics = metrics;
        this.allChannels = allChannels;
        this.sslFileBufferSize = conf.getInt("mapreduce.shuffle.ssl.file.buffer.size", 61440);
        this.connectionKeepAliveEnabled = conf.getBoolean("mapreduce.shuffle.connection-keep-alive.enable", false);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt("mapreduce.shuffle.connection-keep-alive.timeout", 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt("mapreduce.shuffle.mapoutput-info.meta.cache.size", 1000));
        this.manageOsCache = conf.getBoolean("mapreduce.shuffle.manage.os.cache", true);
        this.readaheadLength = conf.getInt("mapreduce.shuffle.readahead.bytes", 0x400000);
        this.maxShuffleConnections = conf.getInt("mapreduce.shuffle.max.connections", 0);
        this.shuffleBufferSize = conf.getInt("mapreduce.shuffle.transfer.buffer.size", 131072);
        this.shuffleTransferToAllowed = conf.getBoolean("mapreduce.shuffle.transferTo.allowed", !Shell.WINDOWS);
        this.maxSessionOpenFiles = conf.getInt("mapreduce.shuffle.max.session-open-files", 3);
    }

    void setPort(int port) {
        this.port = port;
    }
}

