/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableLocator.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableLocator.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final ServerName SN = ServerName.valueOf((String)"example.org", (int)1234, (long)EnvironmentEdgeManager.currentTime());
    private ZKWatcher watcher;
    private Abortable abortable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        this.watcher = new ZKWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable, true);
    }

    @After
    public void after() {
        try {
            MetaTableLocator.deleteMetaLocation((ZKWatcher)this.watcher);
        }
        catch (KeeperException e) {
            LOG.warn("Unable to delete hbase:meta location", (Throwable)e);
        }
        this.watcher.close();
    }

    @Test
    public void testMetaLookup() throws IOException, InterruptedException, ServiceException, KeeperException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        Assert.assertNull((Object)MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher));
        for (RegionState.State state : RegionState.State.values()) {
            if (state.equals((Object)RegionState.State.OPEN)) continue;
            MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)state);
            Assert.assertNull((Object)MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher));
            Assert.assertEquals((Object)state, (Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState());
        }
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPEN);
        Assert.assertEquals((Object)SN, (Object)MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher));
        Assert.assertEquals((Object)RegionState.State.OPEN, (Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState());
        MetaTableLocator.deleteMetaLocation((ZKWatcher)this.watcher);
        Assert.assertNull((Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getServerName());
        Assert.assertEquals((Object)RegionState.State.OFFLINE, (Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState());
        Assert.assertNull((Object)MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher));
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        MetaTableLocator.waitMetaRegionLocation((ZKWatcher)this.watcher, (long)100L);
    }

    @Test
    public void testNoTimeoutWaitForMeta() throws IOException, InterruptedException, KeeperException {
        ServerName hsa = MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher);
        Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread();
        this.startWaitAliveThenWaitItLives(t, 1);
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPEN);
        hsa = SN;
        t.join();
        Assert.assertTrue((boolean)MetaTableLocator.getMetaRegionLocation((ZKWatcher)this.watcher).equals((Object)hsa));
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        UTIL.waitFor(2000L, t::isAlive);
        Threads.sleep((long)ms);
        Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        WaitOnMetaThread() {
            super("WaitOnMeta");
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info("Exiting " + this.getName());
        }

        void doWaiting() throws InterruptedException {
            try {
                while (MetaTableLocator.waitMetaRegionLocation((ZKWatcher)TestMetaTableLocator.this.watcher, (long)10000L) == null) {
                }
            }
            catch (NotAllMetaRegionsOnlineException notAllMetaRegionsOnlineException) {
                // empty catch block
            }
        }
    }
}

