/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TimestampTestBase;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMultiVersions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiVersions.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiVersions.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private Admin admin;
    private static final int NUM_SLAVES = 3;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.admin = UTIL.getAdmin();
    }

    @Test
    public void testTimestamps() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(TimestampTestBase.FAMILY_NAME);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable((TableDescriptor)desc);
        Table table = UTIL.getConnection().getTable(desc.getTableName());
        TimestampTestBase.doTestDelete(table, new TimestampTestBase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getHBaseCluster().flushcache();
            }
        });
        TimestampTestBase.doTestTimestampScanning(table, new TimestampTestBase.FlushCache(){

            @Override
            public void flushcache() throws IOException {
                UTIL.getMiniHBaseCluster().flushcache();
            }
        });
        table.close();
    }

    @Test
    public void testGetRowVersions() throws Exception {
        byte[] contents = Bytes.toBytes((String)"contents");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        long timestamp1 = 100L;
        long timestamp2 = 200L;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(contents);
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        this.admin.createTable((TableDescriptor)desc);
        Put put = new Put(row, 100L);
        put.addColumn(contents, contents, value1);
        Table table = UTIL.getConnection().getTable(desc.getTableName());
        table.put(put);
        table.close();
        UTIL.shutdownMiniHBaseCluster();
        LOG.debug("HBase cluster shut down -- restarting");
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(3).build();
        UTIL.startMiniHBaseCluster(option);
        table = UTIL.getConnection().getTable(desc.getTableName());
        put = new Put(row, 200L);
        put.addColumn(contents, contents, value2);
        table.put(put);
        Get get = new Get(row);
        Result r = table.get(get);
        Assert.assertNotNull((Object)r);
        Assert.assertFalse((boolean)r.isEmpty());
        Assert.assertEquals((long)1L, (long)r.size());
        byte[] value = r.getValue(contents, contents);
        Assert.assertNotEquals((long)0L, (long)value.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])value2));
        get = new Get(row);
        get.setMaxVersions();
        r = table.get(get);
        Assert.assertEquals((long)2L, (long)r.size());
        value = r.getValue(contents, contents);
        Assert.assertNotEquals((long)0L, (long)value.length);
        Assert.assertArrayEquals((byte[])value, (byte[])value2);
        NavigableMap map = r.getMap();
        NavigableMap familyMap = (NavigableMap)map.get(contents);
        NavigableMap versionMap = (NavigableMap)familyMap.get(contents);
        Assert.assertEquals((long)2L, (long)versionMap.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])versionMap.get(100L)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])versionMap.get(200L)));
        table.close();
    }

    @Test
    public void testScanMultipleVersions() throws Exception {
        int count;
        int j;
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        byte[][] rows = new byte[][]{Bytes.toBytes((String)"row_0200"), Bytes.toBytes((String)"row_0800")};
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"row_0500")};
        long[] timestamp = new long[]{100L, 1000L};
        this.admin.createTable((TableDescriptor)desc, (byte[][])splitRows);
        Table table = UTIL.getConnection().getTable(tableName);
        Pair keys = UTIL.getConnection().getRegionLocator(tableName).getStartEndKeys();
        Assert.assertEquals((long)2L, (long)((byte[][])keys.getFirst()).length);
        byte[][] startKeys = (byte[][])keys.getFirst();
        byte[][] endKeys = (byte[][])keys.getSecond();
        for (int i2 = 0; i2 < startKeys.length; ++i2) {
            if (i2 == 0) {
                Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])startKeys[i2]);
                Assert.assertArrayEquals((byte[])endKeys[i2], (byte[])splitRows[0]);
                continue;
            }
            if (i2 != 1) continue;
            Assert.assertArrayEquals((byte[])splitRows[0], (byte[])startKeys[i2]);
            Assert.assertArrayEquals((byte[])endKeys[i2], (byte[])HConstants.EMPTY_END_ROW);
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        for (i = 0; i < startKeys.length; ++i) {
            for (j = 0; j < timestamp.length; ++j) {
                Put put = new Put(rows[i], timestamp[j]);
                put.addColumn(HConstants.CATALOG_FAMILY, null, timestamp[j], Bytes.toBytes((long)timestamp[j]));
                puts.add(put);
            }
        }
        table.put(puts);
        for (i = 0; i < rows.length; ++i) {
            for (j = 0; j < timestamp.length; ++j) {
                Get get = new Get(rows[i]);
                get.addFamily(HConstants.CATALOG_FAMILY);
                get.setTimestamp(timestamp[j]);
                Result result = table.get(get);
                int cellCount = result.rawCells().length;
                Assert.assertEquals((long)1L, (long)cellCount);
            }
        }
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        try (ResultScanner s = table.getScanner(scan);){
            count = Iterables.size((Iterable)s);
        }
        Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        scan = new Scan();
        scan.setTimeRange(1000L, Long.MAX_VALUE);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        var14_16 = null;
        try {
            count = Iterables.size((Iterable)s);
        }
        catch (Throwable throwable) {
            var14_16 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var14_16 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var14_16.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        scan = new Scan();
        scan.setTimestamp(1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        var14_16 = null;
        try {
            count = Iterables.size((Iterable)s);
        }
        catch (Throwable throwable) {
            var14_16 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var14_16 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var14_16.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        scan = new Scan();
        scan.setTimeRange(100L, 1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        var14_16 = null;
        try {
            count = Iterables.size((Iterable)s);
        }
        catch (Throwable throwable) {
            var14_16 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var14_16 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var14_16.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
        scan = new Scan();
        scan.setTimestamp(100L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = table.getScanner(scan);
        var14_16 = null;
        try {
            count = Iterables.size((Iterable)s);
        }
        catch (Throwable throwable) {
            var14_16 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var14_16 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var14_16.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        Assert.assertEquals((String)"Number of rows should be 2", (long)2L, (long)count);
    }
}

