/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ExponentialClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientPushbackTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ClientPushbackTestBase.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final TableName tableName = TableName.valueOf((String)"client-pushback");
    private static final byte[] family = Bytes.toBytes((String)"f");
    private static final byte[] qualifier = Bytes.toBytes((String)"q");
    private static final long flushSizeBytes = 512L;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.client.backpressure.enabled", true);
        conf.setClass("hbase.client.statistics.backoff-policy", ExponentialClientBackoffPolicy.class, ClientBackoffPolicy.class);
        conf.setLong(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, 512L);
        conf.setLong(HConstants.HREGION_MEMSTORE_BLOCK_MULTIPLIER, 4L);
        conf.setBoolean("hbase.client.metrics.enable", true);
        UTIL.startMiniCluster(1);
        UTIL.createTable(tableName, family);
    }

    @AfterClass
    public static void cleanupCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    protected abstract ClientBackoffPolicy getBackoffPolicy() throws IOException;

    protected abstract ServerStatisticTracker getStatisticsTracker() throws IOException;

    protected abstract MetricsConnection getConnectionMetrics() throws IOException;

    protected abstract void mutate(Put var1) throws IOException;

    protected abstract void mutate(Put var1, AtomicLong var2, CountDownLatch var3) throws IOException;

    protected abstract void mutateRow(RowMutations var1) throws IOException;

    @Test
    public void testClientTracksServerPushback() throws Exception {
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        Region region = (Region)rs.getRegions(tableName).get(0);
        LOG.debug("Writing some data to " + tableName);
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.addColumn(family, qualifier, Bytes.toBytes((String)"value1"));
        this.mutate(p);
        int load = (int)(region.getMemStoreHeapSize() * 100L / 512L);
        LOG.debug("Done writing some data to " + tableName);
        ClientBackoffPolicy backoffPolicy = this.getBackoffPolicy();
        Assert.assertTrue((String)"Backoff policy is not correctly configured", (boolean)(backoffPolicy instanceof ExponentialClientBackoffPolicy));
        ServerStatisticTracker stats = this.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        ServerName server = rs.getServerName();
        byte[] regionName = region.getRegionInfo().getRegionName();
        ServerStatistics serverStats = stats.getStats(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        Assert.assertEquals((String)"We did not find some load on the memstore", (long)load, (long)regionStats.getMemStoreLoadPercent());
        long backoffTime = backoffPolicy.getBackoffTime(server, regionName, serverStats);
        Assert.assertNotEquals((String)"Reported load does not produce a backoff", (long)0L, (long)backoffTime);
        LOG.debug("Backoff calculated for " + region.getRegionInfo().getRegionNameAsString() + " @ " + server + " is " + backoffTime);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicLong endTime = new AtomicLong();
        long startTime = EnvironmentEdgeManager.currentTime();
        this.mutate(p, endTime, latch);
        MetricsConnection metrics = this.getConnectionMetrics();
        String name = server.getServerName() + "," + Bytes.toStringBinary((byte[])regionName);
        MetricsConnection.RegionStats rsStats = (MetricsConnection.RegionStats)((ConcurrentMap)metrics.getServerStats().get(server)).get(regionName);
        Assert.assertEquals((Object)name, (Object)rsStats.name);
        Assert.assertEquals((double)rsStats.heapOccupancyHist.getSnapshot().getMean(), (double)regionStats.getHeapOccupancyPercent(), (double)0.1);
        Assert.assertEquals((double)rsStats.memstoreLoadHist.getSnapshot().getMean(), (double)regionStats.getMemStoreLoadPercent(), (double)0.1);
        MetricsConnection.RunnerStats runnerStats = metrics.getRunnerStats();
        Assert.assertEquals((long)1L, (long)runnerStats.delayRunners.getCount());
        Assert.assertEquals((long)1L, (long)runnerStats.normalRunners.getCount());
        Assert.assertEquals((String)"", (double)runnerStats.delayIntevalHist.getSnapshot().getMean(), (double)backoffTime, (double)0.1);
        latch.await(backoffTime * 2L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((String)"AsyncProcess did not submit the work time", (long)0L, (long)endTime.get());
        Assert.assertTrue((String)"AsyncProcess did not delay long enough", (endTime.get() - startTime >= backoffTime ? 1 : 0) != 0);
    }

    @Test
    public void testMutateRowStats() throws IOException {
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        Region region = (Region)rs.getRegions(tableName).get(0);
        RowMutations mutations = new RowMutations(Bytes.toBytes((String)"row"));
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.addColumn(family, qualifier, Bytes.toBytes((String)"value2"));
        mutations.add(p);
        this.mutateRow(mutations);
        ServerStatisticTracker stats = this.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        ServerName server = rs.getServerName();
        byte[] regionName = region.getRegionInfo().getRegionName();
        ServerStatistics serverStats = stats.getStats(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        Assert.assertNotNull((Object)regionStats);
        Assert.assertTrue((regionStats.getMemStoreLoadPercent() > 0 ? 1 : 0) != 0);
    }
}

