/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Test;

public class CloneSnapshotFromClientErrorTestBase
extends CloneSnapshotFromClientTestBase {
    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + EnvironmentEdgeManager.currentTime();
        TableName tableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test(expected=NamespaceNotFoundException.class)
    public void testCloneOnMissingNamespace() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("unknownNS:" + this.getValidMethodName()));
        this.admin.cloneSnapshot(this.snapshotName1, clonedTableName);
    }
}

