/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class TestAdminBase {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final int NB_SERVERS = 3;
    protected static Admin ADMIN;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 30);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        TEST_UTIL.startMiniCluster(3);
        ADMIN = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : ADMIN.listTableDescriptors()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    protected TableState.State getStateFromMeta(TableName table) throws IOException {
        TableState state = MetaTableAccessor.getTableState((Connection)TEST_UTIL.getConnection(), (TableName)table);
        Assert.assertNotNull((Object)state);
        return state.getState();
    }
}

