/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestMasterObserverToModifyTableSchema {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterObserverToModifyTableSchema.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLENAME = TableName.valueOf((String)"TestTable");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", OnlyOneVersionAllowedMasterObserver.class.getName());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterObserverToModifyTableSchema() throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TABLENAME);
        for (int i = 1; i <= 3; ++i) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)("cf" + i))).setMaxVersions(i).build());
        }
        try (Admin admin = UTIL.getAdmin();){
            admin.createTable(builder.build());
            this.assertOneVersion(admin.getDescriptor(TABLENAME));
            builder.modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf1")).setMaxVersions(Integer.MAX_VALUE).build());
            admin.modifyTable(builder.build());
            this.assertOneVersion(admin.getDescriptor(TABLENAME));
        }
    }

    private void assertOneVersion(TableDescriptor td) {
        for (ColumnFamilyDescriptor cfd : td.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)cfd.getMaxVersions());
        }
    }

    public static class OnlyOneVersionAllowedMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public TableDescriptor preCreateTableRegionsInfos(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc) throws IOException {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)desc);
            for (ColumnFamilyDescriptor cfd : desc.getColumnFamilies()) {
                builder.modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd).setMaxVersions(1).build());
            }
            return builder.build();
        }

        public TableDescriptor preModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, TableDescriptor currentDescriptor, TableDescriptor newDescriptor) throws IOException {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)newDescriptor);
            for (ColumnFamilyDescriptor cfd : newDescriptor.getColumnFamilies()) {
                builder.modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd).setMaxVersions(1).build());
            }
            return builder.build();
        }
    }
}

