/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterTestingCluster;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestScanRowPrefix
extends FilterTestingCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScanRowPrefix.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestScanRowPrefix.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testPrefixScanning() throws IOException {
        byte[][] rowIds;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TestScanRowPrefix.createTable(tableName, "F");
        Table table = TestScanRowPrefix.openTable(tableName);
        for (byte[] rowId : rowIds = new byte[][]{{17}, {18}, {18, 35, -1, -2}, {18, 35, -1, -1}, {18, 35, -1, -1, 0}, {18, 35, -1, -1, 1}, {18, 36}, {18, 36, 0}, {18, 36, 0, 0}, {18, 37}, {-1, -1, -1, -1, -1}}) {
            Put p = new Put(rowId);
            p.addColumn("F".getBytes(), rowId, "Dummy value".getBytes());
            table.put(p);
        }
        byte[] prefix0 = new byte[]{};
        ArrayList<byte[]> expected0 = new ArrayList<byte[]>(16);
        expected0.addAll(Arrays.asList(rowIds));
        byte[] prefix1 = new byte[]{18, 35};
        ArrayList<byte[]> expected1 = new ArrayList<byte[]>(16);
        expected1.add(rowIds[2]);
        expected1.add(rowIds[3]);
        expected1.add(rowIds[4]);
        expected1.add(rowIds[5]);
        byte[] prefix2 = new byte[]{18, 35, -1, -1};
        ArrayList<byte[]> expected2 = new ArrayList<byte[]>();
        expected2.add(rowIds[3]);
        expected2.add(rowIds[4]);
        expected2.add(rowIds[5]);
        byte[] prefix3 = new byte[]{18, 36};
        ArrayList<byte[]> expected3 = new ArrayList<byte[]>();
        expected3.add(rowIds[6]);
        expected3.add(rowIds[7]);
        expected3.add(rowIds[8]);
        byte[] prefix4 = new byte[]{-1, -1};
        ArrayList<byte[]> expected4 = new ArrayList<byte[]>();
        expected4.add(rowIds[10]);
        Scan scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix0);
        this.verifyScanResult(table, scan, expected0, "Scan empty prefix failed");
        scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix1);
        this.verifyScanResult(table, scan, expected1, "Scan normal prefix failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected0, "Scan after prefix reset failed");
        scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix1));
        this.verifyScanResult(table, scan, expected1, "Double check on column prefix failed");
        scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix2);
        this.verifyScanResult(table, scan, expected2, "Scan edge 0xFF prefix failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected0, "Scan after prefix reset failed");
        scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix2));
        this.verifyScanResult(table, scan, expected2, "Double check on column prefix failed");
        scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix3);
        this.verifyScanResult(table, scan, expected3, "Scan normal with 0x00 ends failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected0, "Scan after prefix reset failed");
        scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix3));
        this.verifyScanResult(table, scan, expected3, "Double check on column prefix failed");
        scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix4);
        this.verifyScanResult(table, scan, expected4, "Scan end prefix failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected0, "Scan after prefix reset failed");
        scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix4));
        this.verifyScanResult(table, scan, expected4, "Double check on column prefix failed");
        scan = new Scan();
        scan.setStartStopRowForPrefixScan(prefix1);
        this.verifyScanResult(table, scan, expected1, "Prefix filter failed");
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix2));
        this.verifyScanResult(table, scan, expected2, "Combined Prefix + Filter failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected2, "Combined Prefix + Filter; removing Prefix failed");
        scan.setFilter(null);
        this.verifyScanResult(table, scan, expected0, "Scan after Filter reset failed");
        scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(prefix2));
        this.verifyScanResult(table, scan, expected2, "Test filter failed");
        scan.setStartStopRowForPrefixScan(prefix1);
        this.verifyScanResult(table, scan, expected2, "Combined Filter + Prefix failed");
        scan.setFilter(null);
        this.verifyScanResult(table, scan, expected1, "Combined Filter + Prefix ; removing Filter failed");
        scan.setStartStopRowForPrefixScan(null);
        this.verifyScanResult(table, scan, expected0, "Scan after prefix reset failed");
    }

    private void verifyScanResult(Table table, Scan scan, List<byte[]> expectedKeys, String message) {
        ArrayList<byte[]> actualKeys = new ArrayList<byte[]>();
        try {
            ResultScanner scanner = table.getScanner(scan);
            for (Result result : scanner) {
                actualKeys.add(result.getRow());
            }
            String fullMessage = message;
            if (LOG.isDebugEnabled()) {
                fullMessage = message + "\n" + this.tableOfTwoListsOfByteArrays("Expected", expectedKeys, "Actual  ", actualKeys);
            }
            Assert.assertArrayEquals((String)fullMessage, (Object[])expectedKeys.toArray(), (Object[])actualKeys.toArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private String printMultiple(char letter, int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(letter);
        }
        return sb.toString();
    }

    private String tableOfTwoListsOfByteArrays(String label1, List<byte[]> listOfBytes1, String label2, List<byte[]> listOfBytes2) {
        int margin1 = this.calculateWidth(label1, listOfBytes1);
        int margin2 = this.calculateWidth(label2, listOfBytes2);
        StringBuilder sb = new StringBuilder(512);
        String separator = '+' + this.printMultiple('-', margin1 + margin2 + 5) + '+' + '\n';
        sb.append(separator);
        sb.append(this.printLine(label1, margin1, label2, margin2)).append('\n');
        sb.append(separator);
        int maxLength = Math.max(listOfBytes1.size(), listOfBytes2.size());
        for (int offset = 0; offset < maxLength; ++offset) {
            String value1 = this.getStringFromList(listOfBytes1, offset);
            String value2 = this.getStringFromList(listOfBytes2, offset);
            sb.append(this.printLine(value1, margin1, value2, margin2)).append('\n');
        }
        sb.append(separator).append('\n');
        return sb.toString();
    }

    private String printLine(String leftValue, int leftWidth1, String rightValue, int rightWidth) {
        return "| " + leftValue + this.printMultiple(' ', leftWidth1 - leftValue.length()) + " | " + rightValue + this.printMultiple(' ', rightWidth - rightValue.length()) + " |";
    }

    private int calculateWidth(String label1, List<byte[]> listOfBytes1) {
        int longestList1 = label1.length();
        for (byte[] value : listOfBytes1) {
            longestList1 = Math.max(value.length * 2, longestList1);
        }
        return longestList1 + 5;
    }

    private String getStringFromList(List<byte[]> listOfBytes, int offset) {
        String value1 = listOfBytes.size() > offset ? Hex.encodeHexString((byte[])listOfBytes.get(offset)) : "<missing>";
        return value1;
    }
}

