/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, MediumTests.class})
public class TestBlockEvictionOnRegionMovement {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockEvictionOnRegionMovement.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockEvictionOnRegionMovement.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    Path testDir;
    MiniZooKeeperCluster zkCluster;
    MiniHBaseCluster cluster;
    StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).build();

    @Before
    public void setup() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(this.testDir);
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.conf.set("hbase.bucketcache.ioengine", "file:" + this.testDir + "/bucket.cache");
        this.conf.setInt("hbase.bucketcache.size", 400);
        this.conf.set("hbase.bucketcache.persistent.path", this.testDir + "/bucket.persistence");
        this.conf.setLong("hbase.bucketcache.persist.intervalinmillis", 100L);
        this.conf.setBoolean("hbase.rs.evictblocksonclose", true);
        this.conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        this.zkCluster = TEST_UTIL.startMiniZKCluster();
        this.cluster = TEST_UTIL.startMiniHBaseCluster(this.option);
        this.cluster.setConf(this.conf);
    }

    @Test
    public void testBlockEvictionOnRegionMove() throws Exception {
        TableName tableRegionMove = this.writeDataToTable("testBlockEvictionOnRegionMove");
        HRegionServer regionServingRS = this.cluster.getRegionServer(1).getRegions(tableRegionMove).size() == 1 ? this.cluster.getRegionServer(1) : this.cluster.getRegionServer(0);
        Assert.assertTrue((boolean)regionServingRS.getBlockCache().isPresent());
        Waiter.waitFor((Configuration)this.conf, (long)200L, () -> PrefetchExecutor.getPrefetchFutures().isEmpty());
        long oldUsedCacheSize = ((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getCurrentSize();
        Assert.assertNotEquals((long)0L, (long)oldUsedCacheSize);
        Admin admin = TEST_UTIL.getAdmin();
        RegionInfo regionToMove = ((HRegion)regionServingRS.getRegions(tableRegionMove).get(0)).getRegionInfo();
        admin.move(regionToMove.getEncodedNameAsBytes(), TEST_UTIL.getOtherRegionServer(regionServingRS).getServerName());
        Assert.assertEquals((long)0L, (long)regionServingRS.getRegions(tableRegionMove).size());
        long newUsedCacheSize = ((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getCurrentSize();
        Assert.assertTrue((oldUsedCacheSize > newUsedCacheSize ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getBlockCount());
    }

    @Test
    public void testBlockEvictionOnGracefulStop() throws Exception {
        TableName tableRegionClose = this.writeDataToTable("testBlockEvictionOnGracefulStop");
        HRegionServer regionServingRS = this.cluster.getRegionServer(1).getRegions(tableRegionClose).size() == 1 ? this.cluster.getRegionServer(1) : this.cluster.getRegionServer(0);
        Assert.assertTrue((boolean)regionServingRS.getBlockCache().isPresent());
        long oldUsedCacheSize = ((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getCurrentSize();
        Assert.assertNotEquals((long)0L, (long)((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getBlockCount());
        this.cluster.stopRegionServer(regionServingRS.getServerName());
        Thread.sleep(500L);
        this.cluster.startRegionServer();
        Thread.sleep(500L);
        long newUsedCacheSize = ((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getCurrentSize();
        Assert.assertEquals((long)oldUsedCacheSize, (long)newUsedCacheSize);
        Assert.assertNotEquals((long)0L, (long)((BlockCache)regionServingRS.getBlockCache().get()).getBlockCaches()[1].getBlockCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableName writeDataToTable(String testName) throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)(testName + EnvironmentEdgeManager.currentTime()));
        byte[] row0 = Bytes.toBytes((String)"row1");
        byte[] row1 = Bytes.toBytes((String)"row2");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qf1 = Bytes.toBytes((String)"qf1");
        byte[] qf2 = Bytes.toBytes((String)"qf2");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        Table table = TEST_UTIL.createTable(td, (byte[][])null);
        try {
            Put put0 = new Put(row0);
            put0.addColumn(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row1);
            put1.addColumn(family, qf2, 1L, value2);
            table.put(put1);
            TEST_UTIL.flush(tableName);
        }
        finally {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)1L, (long)this.cluster.getRegions(tableName).size());
        return tableName;
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.cleanupDataTestDirOnTestFS(String.valueOf(this.testDir));
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
        }
    }
}

