/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.BadAuthNettyRpcConnection;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FailingNettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyTlsIPC
extends AbstractTestIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyTlsIPC.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility(CONF);
    private static X509TestContextProvider PROVIDER;
    private static NettyEventLoopGroupConfig EVENT_LOOP_GROUP_CONFIG;
    @Parameterized.Parameter(value=1)
    public X509KeyType caKeyType;
    @Parameterized.Parameter(value=2)
    public X509KeyType certKeyType;
    @Parameterized.Parameter(value=3)
    public char[] keyPassword;
    @Parameterized.Parameter(value=4)
    public boolean acceptPlainText;
    @Parameterized.Parameter(value=5)
    public boolean clientTlsEnabled;
    private X509TestContext x509TestContext;

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}, caKeyType={1}, certKeyType={2}, keyPassword={3}, acceptPlainText={4}, clientTlsEnabled={5}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (char[] keyPassword : new char[][]{"".toCharArray(), "pa$$w0rd".toCharArray()}) {
                    params.add(new Object[]{NettyRpcServer.class, caKeyType, certKeyType, keyPassword, false, true});
                    params.add(new Object[]{NettyRpcServer.class, caKeyType, certKeyType, keyPassword, true, true});
                    params.add(new Object[]{NettyRpcServer.class, caKeyType, certKeyType, keyPassword, true, false});
                }
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File dir = new File(UTIL.getDataTestDir(TestNettyTlsIPC.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)dir);
        CONF.setBoolean("hbase.server.netty.tls.enabled", true);
        PROVIDER = new X509TestContextProvider(CONF, dir);
        EVENT_LOOP_GROUP_CONFIG = new NettyEventLoopGroupConfig(CONF, TestNettyTlsIPC.class.getSimpleName());
        NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)CONF, (EventLoopGroup)EVENT_LOOP_GROUP_CONFIG.group(), (Class)EVENT_LOOP_GROUP_CONFIG.clientChannelClass());
        NettyAsyncFSWALConfigHelper.setEventLoopConfig((Configuration)CONF, (EventLoopGroup)EVENT_LOOP_GROUP_CONFIG.group(), (Class)EVENT_LOOP_GROUP_CONFIG.clientChannelClass());
    }

    @AfterClass
    public static void tearDownAfterClass() throws InterruptedException {
        Security.removeProvider("BC");
        EVENT_LOOP_GROUP_CONFIG.group().shutdownGracefully().sync();
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        this.x509TestContext = PROVIDER.get(this.caKeyType, this.certKeyType, this.keyPassword);
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        CONF.setBoolean("hbase.server.netty.tls.supportplaintext", this.acceptPlainText);
        CONF.setBoolean("hbase.client.netty.tls.enabled", this.clientTlsEnabled);
    }

    @After
    public void tearDown() {
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }

    @Override
    protected RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getEventLoopGroupConfig()).thenReturn((Object)EVENT_LOOP_GROUP_CONFIG);
        if (server instanceof HRegionServer) {
            String clusterId = ((HRegionServer)server).getClusterId();
            Mockito.when((Object)mockServer.getClusterId()).thenReturn((Object)clusterId);
        }
        return new NettyRpcServer((Server)mockServer, name, services, bindAddress, conf, scheduler, true);
    }

    @Override
    protected AbstractRpcClient<?> createRpcClientNoCodec(Configuration conf) {
        return new NettyRpcClient(conf){

            protected Codec getCodec() {
                return null;
            }
        };
    }

    @Override
    protected AbstractRpcClient<?> createRpcClient(Configuration conf) {
        return new NettyRpcClient(conf);
    }

    @Override
    protected AbstractRpcClient<?> createRpcClientRTEDuringConnectionSetup(Configuration conf) throws IOException {
        return new NettyRpcClient(conf){

            protected boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }

    @Override
    protected RpcServer createTestFailingRpcServer(String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getEventLoopGroupConfig()).thenReturn((Object)EVENT_LOOP_GROUP_CONFIG);
        return new FailingNettyRpcServer((Server)mockServer, name, services, bindAddress, conf, scheduler);
    }

    @Override
    protected AbstractRpcClient<?> createBadAuthRpcClient(Configuration conf) {
        return new NettyRpcClient(conf){

            protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
                return new BadAuthNettyRpcConnection(this, remoteId);
            }
        };
    }
}

