/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcConnection;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRpcClientLeaks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcClientLeaks.class);
    @Rule
    public TestName name = new TestName();
    private static BlockingQueue<Socket> SAVED_SOCKETS = new LinkedBlockingQueue<Socket>();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    public static final Logger LOG = LoggerFactory.getLogger(TestRpcClientLeaks.class);

    @BeforeClass
    public static void setup() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSocketClosed() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, HBaseTestingUtility.fam1).close();
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.client.impl", MyRpcClientImpl.class.getName());
        conf.setInt("hbase.client.retries.number", 2);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(TableName.valueOf((String)this.name.getMethodName()));){
            MyRpcClientImpl.enableThrowExceptions();
            table.get(new Get(Bytes.toBytes((String)"asd")));
            Assert.fail((String)"Should fail because the injected error");
        }
        catch (RetriesExhaustedException retriesExhaustedException) {
            // empty catch block
        }
        for (Socket socket : SAVED_SOCKETS) {
            Assert.assertTrue((String)("Socket " + socket + " is not closed"), (boolean)socket.isClosed());
        }
    }

    public static class MyRpcClientImpl
    extends BlockingRpcClient {
        private static boolean throwException = false;

        public MyRpcClientImpl(Configuration conf) {
            super(conf);
        }

        public MyRpcClientImpl(Configuration conf, String clusterId, SocketAddress address, MetricsConnection metrics, Map<String, byte[]> connectionAttributes) {
            super(conf, clusterId, address, metrics, connectionAttributes);
        }

        protected BlockingRpcConnection createConnection(ConnectionId remoteId) throws IOException {
            return new BlockingRpcConnection(this, remoteId){

                protected synchronized void setupConnection() throws IOException {
                    super.setupConnection();
                    if (throwException) {
                        SAVED_SOCKETS.add(this.socket);
                        throw new IOException("Sample exception for verifying socket closure in case of exceptions.");
                    }
                }
            };
        }

        public static void enableThrowExceptions() {
            throwException = true;
        }
    }
}

