/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MetricsMasterProcSource;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterMetrics.class);
    private static final MetricsAssertHelper metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static MiniHBaseCluster cluster;
    private static HMaster master;
    private static HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info("Starting cluster");
        TEST_UTIL = new HBaseTestingUtility();
        StartMiniClusterOption option = StartMiniClusterOption.builder().masterClass(MyMaster.class).build();
        TEST_UTIL.startMiniCluster(option);
        cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        master = cluster.getMaster();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test
    public void testClusterRequests() throws Exception {
        RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
        ServerName serverName = cluster.getMaster(0).getServerName();
        request.setServer(ProtobufUtil.toServerName((ServerName)serverName));
        long expectedRequestNumber = 10000L;
        MetricsMasterSource masterSource = master.getMasterMetrics().getMetricsSource();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().setTotalNumberOfRequests(expectedRequestNumber).build();
        request.setLoad(sl);
        master.getMasterRpcServices().regionServerReport(null, request.build());
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        if (tablesOnMaster) {
            metricsHelper.assertCounter("cluster_requests", expectedRequestNumber, (BaseSource)masterSource);
        } else {
            metricsHelper.assertCounterGt("cluster_requests", expectedRequestNumber, (BaseSource)masterSource);
        }
        expectedRequestNumber = 15000L;
        sl = ClusterStatusProtos.ServerLoad.newBuilder().setTotalNumberOfRequests(expectedRequestNumber).build();
        request.setLoad(sl);
        master.getMasterRpcServices().regionServerReport(null, request.build());
        if (tablesOnMaster) {
            metricsHelper.assertCounter("cluster_requests", expectedRequestNumber, (BaseSource)masterSource);
        } else {
            metricsHelper.assertCounterGt("cluster_requests", expectedRequestNumber, (BaseSource)masterSource);
        }
        master.stopMaster();
    }

    @Test
    public void testDefaultMasterMetrics() throws Exception {
        MetricsMasterSource masterSource = master.getMasterMetrics().getMetricsSource();
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        metricsHelper.assertGauge("numRegionServers", (long)(1 + (tablesOnMaster ? 1 : 0)), (BaseSource)masterSource);
        metricsHelper.assertGauge("averageLoad", (long)(1 + (tablesOnMaster ? 0 : 1)), (BaseSource)masterSource);
        metricsHelper.assertGauge("numDeadRegionServers", 0L, (BaseSource)masterSource);
        metricsHelper.assertGauge("numDrainingRegionServers", 0L, (BaseSource)masterSource);
        metricsHelper.assertGauge("masterStartTime", master.getMasterStartTime(), (BaseSource)masterSource);
        metricsHelper.assertGauge("masterActiveTime", master.getMasterActiveTime(), (BaseSource)masterSource);
        metricsHelper.assertTag("isActiveMaster", "true", (BaseSource)masterSource);
        metricsHelper.assertTag("serverName", master.getServerName().toString(), (BaseSource)masterSource);
        metricsHelper.assertTag("clusterId", master.getClusterId(), (BaseSource)masterSource);
        metricsHelper.assertTag("zookeeperQuorum", master.getZooKeeper().getQuorum(), (BaseSource)masterSource);
        metricsHelper.assertCounter("serverCrashSubmittedCount", 0L, (BaseSource)masterSource);
        metricsHelper.assertGauge("oldWALsDirSize", master.getMasterWalManager().getOldWALsDirSize(), (BaseSource)masterSource);
    }

    @Test
    public void testDefaultMasterProcMetrics() throws Exception {
        MetricsMasterProcSource masterSource = master.getMasterMetrics().getMetricsProcSource();
        metricsHelper.assertGauge("numMasterWALs", (long)master.getNumWALFiles(), (BaseSource)masterSource);
    }

    public static class MyMaster
    extends HMaster {
        public MyMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) {
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new MasterRpcServices(this){

                public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
                    RegionServerStatusProtos.RegionServerStartupResponse resp = super.regionServerStartup(controller, request);
                    ServerManager serverManager = this.getServerManager();
                    new HashMap<ServerName, ServerMetrics>(serverManager.getOnlineServers()).forEach((sn, sm) -> {
                        if (sm.getLastReportTimestamp() <= 0L) {
                            try {
                                serverManager.regionServerReport(sn, ServerMetricsBuilder.newBuilder((ServerName)sn).setVersionNumber(sm.getVersionNumber()).setVersion(sm.getVersion()).setLastReportTimestamp(EnvironmentEdgeManager.currentTime()).build());
                            }
                            catch (YouAreDeadException e) {
                                throw new UncheckedIOException((IOException)((Object)e));
                            }
                        }
                    });
                    return resp;
                }
            };
        }
    }
}

