/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.DummyCostFunction;
import org.apache.hadoop.hbase.master.balancer.MemStoreSizeCostFunction;
import org.apache.hadoop.hbase.master.balancer.MoveCostFunction;
import org.apache.hadoop.hbase.master.balancer.PrimaryRegionCountSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.RackLocalityCostFunction;
import org.apache.hadoop.hbase.master.balancer.ReadRequestCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionCountSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaHostCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaRackCostFunction;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.ServerLocalityCostFunction;
import org.apache.hadoop.hbase.master.balancer.StoreFileCostFunction;
import org.apache.hadoop.hbase.master.balancer.TableSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.WriteRequestCostFunction;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancer.class);
    private static final String REGION_KEY = "testRegion";
    private float[] expectedLocalities = new float[]{1.0f, 0.0f, 0.5f, 0.25f, 1.0f};
    private static Configuration storedConfiguration;
    private int[][][] clusterRegionLocationMocks = new int[][][]{new int[][]{{2, 1, 1}, {2, 0, 0, 100}, {0, 100, 0, 0}, {0, 100, 0, 0}, {1, 0, 100, 0}}, new int[][]{{1, 2, 1}, {0, 0, 0, 100}, {1, 100, 0, 0}, {1, 100, 0, 0}, {2, 0, 100, 0}}, new int[][]{{1, 2, 1}, {0, 25, 0, 50}, {1, 50, 25, 0}, {1, 50, 25, 0}, {2, 0, 50, 25}}, new int[][]{{1, 2, 1}, {0, 25, 0, 100}, {1, 100, 25, 0}, {1, 100, 25, 0}, {2, 0, 100, 25}}, new int[][]{{1, 2, 1}, {0, 75, 75, 75}, {1, 75, 75, 75}, {1, 75, 75, 75}, {2, 75, 75, 75}}};

    @BeforeClass
    public static void saveInitialConfiguration() {
        storedConfiguration = new Configuration(conf);
    }

    @Before
    public void beforeEachTest() {
        conf = new Configuration(storedConfiguration);
        loadBalancer.onConfigurationChange(conf);
    }

    @Test
    public void testKeepRegionLoad() throws Exception {
        ServerName sn = ServerName.valueOf((String)"test:8080", (long)100L);
        int numClusterStatusToAdd = 20000;
        for (int i = 0; i < numClusterStatusToAdd; ++i) {
            ServerMetrics sl = (ServerMetrics)Mockito.mock(ServerMetrics.class);
            RegionMetrics rl = (RegionMetrics)Mockito.mock(RegionMetrics.class);
            Mockito.when((Object)rl.getReadRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getWriteRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getMemStoreSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)rl.getStoreFileSize()).thenReturn((Object)new Size((double)i, Size.Unit.MEGABYTE));
            Mockito.when((Object)rl.getRegionSizeMB()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)Float.valueOf(rl.getCurrentRegionCachedRatio())).thenReturn((Object)Float.valueOf(0.0f));
            TreeMap<byte[], RegionMetrics> regionLoadMap = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
            regionLoadMap.put(Bytes.toBytes((String)REGION_KEY), rl);
            Mockito.when((Object)sl.getRegionMetrics()).thenReturn(regionLoadMap);
            ClusterMetrics clusterStatus = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
            TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
            serverMetricsMap.put(sn, sl);
            Mockito.when((Object)clusterStatus.getLiveServerMetrics()).thenReturn(serverMetricsMap);
            loadBalancer.updateClusterMetrics(clusterStatus);
        }
        String regionNameAsString = RegionInfo.getRegionNameAsString((byte[])Bytes.toBytes((String)REGION_KEY));
        Assert.assertTrue((TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString) != null ? 1 : 0) != 0);
        Assert.assertTrue((((Deque)TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString)).size() == 15 ? 1 : 0) != 0);
        Assert.assertNull((Object)TestStochasticLoadBalancer.loadBalancer.namedQueueRecorder);
        Queue loads = (Queue)TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString);
        int i = 0;
        while (loads.size() > 0) {
            BalancerRegionLoad rl = (BalancerRegionLoad)loads.remove();
            Assert.assertEquals((long)(i + (numClusterStatusToAdd - 15)), (long)rl.getStorefileSizeMB());
            ++i;
        }
    }

    @Test
    public void testUpdateBalancerLoadInfo() {
        boolean[] perTableBalancerConfigs;
        int[] cluster = new int[]{10, 0};
        TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(cluster);
        BalancerClusterState clusterState = this.mockCluster(cluster);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(servers);
        for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
            conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
            loadBalancer.onConfigurationChange(conf);
            dummyMetricsStochasticBalancer.clearDummyMetrics();
            loadBalancer.updateBalancerLoadInfo(LoadOfAllTable);
            Assert.assertTrue((String)"Metrics should be recorded!", (dummyMetricsStochasticBalancer.getDummyCostsMap() != null && !dummyMetricsStochasticBalancer.getDummyCostsMap().isEmpty() ? 1 : 0) != 0);
            String metricRecordKey = isByTable ? "table1#Overall" : HConstants.ENSEMBLE_TABLE_NAME + "#" + "Overall";
            double curOverallCost = loadBalancer.computeCost(clusterState, Double.MAX_VALUE);
            double curOverallCostInMetrics = dummyMetricsStochasticBalancer.getDummyCostsMap().get(metricRecordKey);
            Assert.assertEquals((double)curOverallCost, (double)curOverallCostInMetrics, (double)0.001);
        }
    }

    @Test
    public void testUpdateStochasticCosts() {
        int[] cluster = new int[]{10, 0};
        TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(cluster);
        BalancerClusterState clusterState = this.mockCluster(cluster);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setBoolean("hbase.master.loadbalance.bytable", false);
        loadBalancer.onConfigurationChange(conf);
        dummyMetricsStochasticBalancer.clearDummyMetrics();
        List plans = loadBalancer.balanceCluster(this.mockClusterServersWithTables(servers));
        Assert.assertTrue((String)"Balance plan should not be empty!", (plans != null && !plans.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"There should be metrics record in MetricsStochasticBalancer", (!dummyMetricsStochasticBalancer.getDummyCostsMap().isEmpty() ? 1 : 0) != 0);
        double overallCostOfCluster = loadBalancer.computeCost(clusterState, Double.MAX_VALUE);
        double overallCostInMetrics = dummyMetricsStochasticBalancer.getDummyCostsMap().get(HConstants.ENSEMBLE_TABLE_NAME + "#" + "Overall");
        Assert.assertEquals((double)overallCostOfCluster, (double)overallCostInMetrics, (double)0.001);
    }

    @Test
    public void testUpdateStochasticCostsIfBalanceNotRan() {
        int[] cluster = new int[]{10, 10};
        TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(cluster);
        BalancerClusterState clusterState = this.mockCluster(cluster);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", Float.MAX_VALUE);
        conf.setBoolean("hbase.master.loadbalance.bytable", false);
        loadBalancer.onConfigurationChange(conf);
        dummyMetricsStochasticBalancer.clearDummyMetrics();
        List plans = loadBalancer.balanceCluster(this.mockClusterServersWithTables(servers));
        Assert.assertTrue((String)"Balance plan should be empty!", (plans == null || plans.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"There should be metrics record in MetricsStochasticBalancer!", (!dummyMetricsStochasticBalancer.getDummyCostsMap().isEmpty() ? 1 : 0) != 0);
        double overallCostOfCluster = loadBalancer.computeCost(clusterState, Double.MAX_VALUE);
        double overallCostInMetrics = dummyMetricsStochasticBalancer.getDummyCostsMap().get(HConstants.ENSEMBLE_TABLE_NAME + "#" + "Overall");
        Assert.assertEquals((double)overallCostOfCluster, (double)overallCostInMetrics, (double)0.001);
    }

    @Test
    public void testNeedBalance() {
        boolean[] perTableBalancerConfigs;
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setFloat("hbase.regions.slop", -1.0f);
        conf.setBoolean("hbase.master.balancer.stochastic.runMaxSteps", false);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 5000L);
        for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
            conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
            loadBalancer.onConfigurationChange(conf);
            for (int[] mockCluster : this.clusterStateMocks) {
                Assert.assertTrue((this.hasEmptyBalancerPlans(mockCluster) || this.needsBalanceIdleRegion(mockCluster) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testBalanceOfSloppyServers() {
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setBoolean("hbase.master.balancer.stochastic.runMaxSteps", false);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 5000L);
        loadBalancer.onConfigurationChange(conf);
        for (int[] mockCluster : this.clusterStateMocksWithNoSlop) {
            Assert.assertTrue((boolean)this.hasEmptyBalancerPlans(mockCluster));
        }
        for (int[] mockCluster : this.clusterStateMocksWithSlop) {
            Assert.assertFalse((boolean)this.hasEmptyBalancerPlans(mockCluster));
        }
    }

    @Test
    public void testSloppyTablesLoadBalanceByTable() {
        int[][] regionsPerServerPerTable = new int[][]{{8, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}, {2, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setBoolean("hbase.master.balancer.stochastic.runMaxSteps", false);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 5000L);
        conf.setBoolean("hbase.master.loadbalance.bytable", true);
        loadBalancer.onConfigurationChange(conf);
        Assert.assertFalse((boolean)this.hasEmptyBalancerPlans(regionsPerServerPerTable));
    }

    private boolean hasEmptyBalancerPlans(int[] mockCluster) {
        TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(mockCluster);
        return this.hasEmptyBalancerPlans(servers);
    }

    private boolean hasEmptyBalancerPlans(int[][] mockCluster) {
        TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(mockCluster);
        return this.hasEmptyBalancerPlans(servers);
    }

    private boolean hasEmptyBalancerPlans(Map<ServerName, List<RegionInfo>> servers) {
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> loadOfAllTable = this.mockClusterServersWithTables(servers);
        List plans = loadBalancer.balanceCluster(loadOfAllTable);
        return plans == null || plans.isEmpty();
    }

    @Test
    public void testLocalityCost() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ServerLocalityCostFunction costFunction = new ServerLocalityCostFunction(conf);
        for (int test = 0; test < this.clusterRegionLocationMocks.length; ++test) {
            int[][] clusterRegionLocations = this.clusterRegionLocationMocks[test];
            MockCluster cluster = new MockCluster(clusterRegionLocations);
            costFunction.prepare((BalancerClusterState)cluster);
            double cost = costFunction.cost();
            double expected = 1.0f - this.expectedLocalities[test];
            Assert.assertEquals((double)expected, (double)cost, (double)0.001);
        }
        Assert.assertNull((Object)TestStochasticLoadBalancer.loadBalancer.namedQueueRecorder);
    }

    @Test
    public void testMoveCostMultiplier() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        MoveCostFunction costFunction = new MoveCostFunction(conf);
        BalancerClusterState cluster = this.mockCluster(this.clusterStateMocks[0]);
        costFunction.prepare(cluster);
        costFunction.cost();
        Assert.assertEquals((double)7.0, (double)costFunction.getMultiplier(), (double)0.01);
        conf.setInt("hbase.offpeak.start.hour", 0);
        conf.setInt("hbase.offpeak.end.hour", 23);
        long deltaFor15 = TimeZone.getDefault().getRawOffset() - 28800000;
        long timeFor15 = 1597907081000L - deltaFor15;
        EnvironmentEdgeManager.injectEdge(() -> timeFor15);
        costFunction = new MoveCostFunction(conf);
        costFunction.prepare(cluster);
        costFunction.cost();
        Assert.assertEquals((double)3.0, (double)costFunction.getMultiplier(), (double)0.01);
    }

    @Test
    public void testMoveCost() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        MoveCostFunction costFunction = new MoveCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BalancerClusterState cluster = this.mockCluster(mockCluster);
            costFunction.prepare(cluster);
            double cost = costFunction.cost();
            Assert.assertEquals((double)0.0, (double)cost, (double)0.001);
            cluster.setNumRegions(200);
            cluster.setNumMovedRegions(10);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.05f, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(100);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.5, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(200);
            cost = costFunction.cost();
            Assert.assertEquals((double)1.0, (double)cost, (double)0.001);
            cluster.setNumRegions(10000);
            cluster.setNumMovedRegions(250);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.025f, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(1250);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.125, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(2500);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.25, (double)cost, (double)0.01);
        }
    }

    @Test
    public void testSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        RegionCountSkewCostFunction costFunction = new RegionCountSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            costFunction.prepare(this.mockCluster(mockCluster));
            double cost = costFunction.cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
        costFunction.prepare(this.mockCluster(new int[]{0, 0, 0, 0, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.prepare(this.mockCluster(new int[]{0, 0, 0, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.prepare(this.mockCluster(new int[]{0, 0, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.prepare(this.mockCluster(new int[]{0, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.prepare(this.mockCluster(new int[]{1, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.prepare(this.mockCluster(new int[]{10000, 0, 0, 0, 0}));
        Assert.assertEquals((double)1.0, (double)costFunction.cost(), (double)0.01);
    }

    @Test
    public void testCostAfterUndoAction() {
        int runs = 10;
        for (int[] mockCluster : this.clusterStateMocks) {
            BalancerClusterState cluster = this.mockCluster(mockCluster);
            loadBalancer.initCosts(cluster);
            for (int i = 0; i != 10; ++i) {
                double expectedCost = loadBalancer.computeCost(cluster, Double.MAX_VALUE);
                BalanceAction action = (BalanceAction)loadBalancer.nextAction(cluster).getSecond();
                cluster.doAction(action);
                loadBalancer.updateCostsAndWeightsWithAction(cluster, action);
                BalanceAction undoAction = action.undoAction();
                cluster.doAction(undoAction);
                loadBalancer.updateCostsAndWeightsWithAction(cluster, undoAction);
                double actualCost = loadBalancer.computeCost(cluster, Double.MAX_VALUE);
                Assert.assertEquals((double)expectedCost, (double)actualCost, (double)0.0);
            }
        }
    }

    @Test
    public void testTableSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        TableSkewCostFunction costFunction = new TableSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BalancerClusterState cluster = this.mockCluster(mockCluster);
            costFunction.prepare(cluster);
            double cost = costFunction.cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRegionLoadCost() {
        ArrayList<BalancerRegionLoad> regionLoads = new ArrayList<BalancerRegionLoad>();
        for (int i = 1; i < 5; ++i) {
            BalancerRegionLoad regionLoad = (BalancerRegionLoad)Mockito.mock(BalancerRegionLoad.class);
            Mockito.when((Object)regionLoad.getReadRequestsCount()).thenReturn((Object)new Long(i));
            Mockito.when((Object)regionLoad.getStorefileSizeMB()).thenReturn((Object)i);
            regionLoads.add(regionLoad);
        }
        Configuration conf = HBaseConfiguration.create();
        ReadRequestCostFunction readCostFunction = new ReadRequestCostFunction(conf);
        double rateResult = readCostFunction.getRegionLoadCost(regionLoads);
        Assert.assertEquals((double)1.0, (double)rateResult, (double)0.01);
        StoreFileCostFunction storeFileCostFunction = new StoreFileCostFunction(conf);
        double result = storeFileCostFunction.getRegionLoadCost(regionLoads);
        Assert.assertEquals((double)2.5, (double)result, (double)0.01);
    }

    @Test
    public void testRegionLoadCostWhenDecrease() {
        ArrayList<BalancerRegionLoad> regionLoads = new ArrayList<BalancerRegionLoad>();
        for (int i = 1; i < 5; ++i) {
            int load = i == 3 ? 1 : i;
            BalancerRegionLoad regionLoad = (BalancerRegionLoad)Mockito.mock(BalancerRegionLoad.class);
            Mockito.when((Object)regionLoad.getReadRequestsCount()).thenReturn((Object)load);
            regionLoads.add(regionLoad);
        }
        Configuration conf = HBaseConfiguration.create();
        ReadRequestCostFunction readCostFunction = new ReadRequestCostFunction(conf);
        double rateResult = readCostFunction.getRegionLoadCost(regionLoads);
        Assert.assertEquals((double)1.67, (double)rateResult, (double)0.01);
    }

    @Test
    public void testLosingRs() throws Exception {
        int numNodes = 3;
        int numRegions = 20;
        int numRegionsPerServer = 3;
        int replication = 1;
        int numTables = 2;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        List<ServerAndLoad> list = this.convertToList(serverMap);
        List plans = loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
        Assert.assertNotNull((Object)plans);
        List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
        this.assertClusterAsBalanced(balancedCluster);
        ServerName sn = serverMap.keySet().toArray(new ServerName[serverMap.size()])[0];
        ServerName deadSn = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 100L));
        serverMap.put(deadSn, new ArrayList(0));
        plans = loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
        Assert.assertNull((Object)plans);
    }

    @Test
    public void testAdditionalCostFunction() {
        conf.set("hbase.master.balancer.stochastic.additionalCostFunctions", DummyCostFunction.class.getName());
        loadBalancer.onConfigurationChange(conf);
        Assert.assertTrue((boolean)Arrays.asList(loadBalancer.getCostFunctionNames()).contains(DummyCostFunction.class.getSimpleName()));
    }

    @Test
    public void testDefaultCostFunctionList() {
        List<String> expected = Arrays.asList(RegionCountSkewCostFunction.class.getSimpleName(), PrimaryRegionCountSkewCostFunction.class.getSimpleName(), MoveCostFunction.class.getSimpleName(), RackLocalityCostFunction.class.getSimpleName(), TableSkewCostFunction.class.getSimpleName(), RegionReplicaHostCostFunction.class.getSimpleName(), RegionReplicaRackCostFunction.class.getSimpleName(), ReadRequestCostFunction.class.getSimpleName(), WriteRequestCostFunction.class.getSimpleName(), MemStoreSizeCostFunction.class.getSimpleName(), StoreFileCostFunction.class.getSimpleName());
        List<String> actual = Arrays.asList(loadBalancer.getCostFunctionNames());
        Assert.assertTrue((String)("ExpectedCostFunctions: " + expected + " ActualCostFunctions: " + actual), (boolean)CollectionUtils.isEqualCollection(expected, actual));
    }

    private boolean needsBalanceIdleRegion(int[] cluster) {
        return Arrays.stream(cluster).anyMatch(x -> x > 1) && Arrays.stream(cluster).anyMatch(x -> x < 1);
    }

    private class MockCluster
    extends BalancerClusterState {
        private int[][] localities;

        public MockCluster(int[][] regions) {
            super(TestStochasticLoadBalancer.this.mockClusterServers(regions[0], 1), null, null, null);
            this.localities = null;
            this.localities = new int[regions.length - 1][];
            for (int i = 1; i < regions.length; ++i) {
                int regionIndex = i - 1;
                this.localities[regionIndex] = new int[regions[i].length - 1];
                this.regionIndexToServerIndex[regionIndex] = regions[i][0];
                for (int j = 1; j < regions[i].length; ++j) {
                    int serverIndex = j - 1;
                    this.localities[regionIndex][serverIndex] = regions[i][j] > 100 ? regions[i][j] % 100 : regions[i][j];
                }
            }
        }

        float getLocalityOfRegion(int region, int server) {
            return (float)this.localities[region][server] / 100.0f;
        }

        public int getRegionSizeMB(int region) {
            return 1;
        }
    }
}

