/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDisableTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDisableTableProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDisableTableProcedure.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testDisableTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableIsDisabled(this.getMaster(), tableName);
    }

    @Test
    public void testDisableTableMultipleTimes() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        long procId1 = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateTableIsDisabled(this.getMaster(), tableName);
        TableNotEnabledException e = null;
        Throwable cause = null;
        try {
            long procId2 = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
            Procedure result = procExec.getResult(procId2);
            Assert.assertTrue((boolean)result.isFailed());
            cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
            e = result.getException();
        }
        catch (TableNotEnabledException tnde) {
            e = tnde;
            cause = tnde;
        }
        LOG.debug("Disable failed with exception {}" + (Object)((Object)e));
        Assert.assertTrue((boolean)(cause instanceof TableNotEnabledException));
        try {
            ProcedurePrepareLatch.CompatibilityLatch prepareLatch = new ProcedurePrepareLatch.CompatibilityLatch();
            long procId3 = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false, (ProcedurePrepareLatch)prepareLatch));
            prepareLatch.await();
            Assert.fail((String)"Disable should throw exception through latch.");
        }
        catch (TableNotEnabledException tnee) {
            LOG.debug("Disable failed with expected exception {}", (Throwable)tnee);
        }
        try {
            long procId4 = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId4);
            ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId4);
        }
        catch (TableNotEnabledException tnee) {
            LOG.debug("Disable failed with expected exception {}", (Throwable)tnee);
        }
        MasterProcedureTestingUtility.validateTableIsDisabled(this.getMaster(), tableName);
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, "f1", "f2");
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableIsDisabled(this.getMaster(), tableName);
    }
}

