/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReopenTableRegionsProcedureBatchBackoff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReopenTableRegionsProcedureBatchBackoff.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"BatchBackoff");
    private static final int BACKOFF_MILLIS_PER_RS = 3000;
    private static final int REOPEN_BATCH_SIZE_MAX = 8;
    private static final int NUM_REGIONS = 10;
    private static final int NUM_BATCHES = 4;
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.startMiniCluster(1);
        UTIL.createMultiRegionTable(TABLE_NAME, CF, 10);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionBatchBackoff() throws IOException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regions = UTIL.getAdmin().getRegions(TABLE_NAME);
        Assert.assertTrue((10 <= regions.size() ? 1 : 0) != 0);
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME, 3000L, 8);
        procExec.submitProcedure((Procedure)proc);
        Instant startedAt = Instant.now();
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)60000L);
        Instant stoppedAt = Instant.now();
        Assert.assertTrue((Duration.between(startedAt, stoppedAt).toMillis() > 9000L ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)proc.getBatchesProcessed());
    }

    @Test
    public void testRegionBatchNoBackoff() throws IOException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regions = UTIL.getAdmin().getRegions(TABLE_NAME);
        Assert.assertTrue((10 <= regions.size() ? 1 : 0) != 0);
        int noBackoffMillis = 0;
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME, (long)noBackoffMillis, 8);
        procExec.submitProcedure((Procedure)proc);
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)((long)regions.size() * 3000L));
        Assert.assertEquals((long)4L, (long)proc.getBatchesProcessed());
    }
}

