/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MockHStoreFile;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.TestCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.TimeOffsetEnvironmentEdge;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDefaultCompactSelection
extends TestCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultCompactSelection.class);

    @Override
    protected void config() {
        super.config();
        this.conf.setLong(HStore.BLOCKING_STOREFILES_KEY, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionRatio() throws IOException {
        TimeOffsetEnvironmentEdge edge = new TimeOffsetEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        long tooBig = 2101L;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), 23L, 12L, 12L);
        this.compactEquals(this.sfCreate(100L, 50L, 25L, 12L, 12L), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L, 700L), 700L, 700L, 700L);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L), new long[0]);
        this.compactEquals(this.sfCreate(7L, 1L, 1L), 7L, 1L, 1L);
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 5L, 4L, 3L, 2L, 1L);
        this.compactEquals(this.sfCreate(50L, 10L, 10L, 10L, 10L), 10L, 10L, 10L, 10L);
        this.compactEquals(this.sfCreate(10L, 10L, 10L, 10L, 50L), 10L, 10L, 10L, 10L);
        this.compactEquals(this.sfCreate(251L, 253L, 251L, 2099L), 251L, 253L, 251L);
        this.compactEquals(this.sfCreate(2099L, 2099L, 2099L), new long[0]);
        this.conf.setLong("hbase.hstore.compaction.min.size", 1L);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L), 4L, 2L, 1L);
        this.conf.setLong("hbase.hstore.compaction.min.size", 10L);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(50L, 25L, 12L, 12L), true, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(12L, 12L), true, 12L, 12L);
        this.compactEquals(this.sfCreate(tooBig, 12L, 12L), true, tooBig, 12L, 12L);
        this.store.forceMajor = true;
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 5L, 4L, 3L, 2L, 1L);
        this.store.forceMajor = false;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), true, 23L, 12L, 12L);
        this.conf.setLong(HConstants.MAJOR_COMPACTION_PERIOD, 1L);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.0f);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        try {
            List<HStoreFile> candidates = this.sfCreate(50L, 25L, 12L, 12L);
            edge.increment(2L);
            this.compactEquals(candidates, 50L, 25L, 12L, 12L);
            candidates = this.sfCreate(100L, 50L, 23L, 12L, 12L);
            edge.increment(2L);
            this.compactEquals(candidates, 23L, 12L, 12L);
        }
        finally {
            this.conf.setLong(HConstants.MAJOR_COMPACTION_PERIOD, 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
        }
        this.compactEquals(this.sfCreate(true, 100L, 50L, 25L, 12L, 12L), 100L, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(true, tooBig, 12L, 12L), tooBig, 12L, 12L);
        this.compactEquals(this.sfCreate(true, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 7L, 6L, 5L, 4L, 3L);
        this.compactEquals(new ArrayList<HStoreFile>(), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig), new long[0]);
    }

    @Test
    public void testOffPeakCompactionRatio() throws IOException {
        this.conf.setFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), false, true, 50L, 12L, 12L, 1L);
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), 12L, 12L, 1L);
    }

    @Test
    public void testStuckStoreCompaction() throws IOException {
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 30L), 30L, 30L, 30L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 30L), 99L, 30L, 30L, 30L, 30L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 15L), 30L, 30L, 30L, 15L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 30L, 26L, 26L, 29L, 25L, 25L), 30L, 26L, 26L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 27L, 27L, 27L, 20L, 20L, 20L), 20L, 20L, 20L);
    }

    @Test
    public void testCompactionEmptyHFile() throws IOException {
        ScanInfo oldScanInfo = this.store.getScanInfo();
        ScanInfo newScanInfo = oldScanInfo.customize(oldScanInfo.getMaxVersions(), 600L, oldScanInfo.getKeepDeletedCells());
        this.store.setScanInfo(newScanInfo);
        List<HStoreFile> candidates = this.sfCreate(0L);
        for (HStoreFile file : candidates) {
            if (!(file instanceof MockHStoreFile)) continue;
            MockHStoreFile mockFile = (MockHStoreFile)file;
            mockFile.setTimeRangeTracker(TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.SYNC, (long)-1L, (long)-1L));
            mockFile.setEntries(0L);
        }
        CompactionRequestImpl result = ((RatioBasedCompactionPolicy)this.store.storeEngine.getCompactionPolicy()).selectCompaction(candidates, new ArrayList(), false, false, false);
        Assert.assertTrue((boolean)result.getFiles().isEmpty());
        this.store.setScanInfo(oldScanInfo);
    }
}

