/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class, RegionServerTests.class})
@RunWith(value=Parameterized.class)
public class TestStoreFileWriter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileWriter.class);
    private final int ROW_NUM = 100;
    private final Random RANDOM = new Random(11L);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private HRegion[] regions = new HRegion[2];
    private final byte[][] qualifiers = new byte[][]{Bytes.toBytes((String)"0"), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2")};
    private ArrayList<ArrayList<ArrayList<CellInfo>>> insertedCells;
    private TableName[] tableName = new TableName[2];
    private final Configuration conf = UTIL.getConfiguration();
    private int flushCount = 0;
    @Parameterized.Parameter(value=0)
    public KeepDeletedCells keepDeletedCells;
    @Parameterized.Parameter(value=1)
    public int maxVersions;
    @Parameterized.Parameter(value=2)
    public boolean newVersionBehavior;

    @Parameterized.Parameters(name="keepDeletedCells={0}, maxVersions={1}, newVersionBehavior={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({KeepDeletedCells.FALSE, 1, true}, {KeepDeletedCells.FALSE, 2, false}, {KeepDeletedCells.FALSE, 3, true}, {KeepDeletedCells.TRUE, 1, false}, {KeepDeletedCells.TRUE, 3, false});
    }

    private void createTable(int index, boolean enableDualFileWriter) throws IOException {
        this.tableName[index] = TableName.valueOf((String)(this.getClass().getSimpleName() + "_" + index));
        ColumnFamilyDescriptor familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])HBaseTestingUtility.fam1).setMaxVersions(this.maxVersions).setKeepDeletedCells(this.keepDeletedCells).setValue("NEW_VERSION_BEHAVIOR", Boolean.toString(this.newVersionBehavior)).build();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName[index]).setColumnFamily(familyDescriptor).setValue("hbase.enable.historical.compaction.files", Boolean.toString(enableDualFileWriter));
        UTIL.createTable(builder.build(), (byte[][])null);
        this.regions[index] = UTIL.getMiniHBaseCluster().getRegions(this.tableName[index]).get(0);
    }

    @Before
    public void setUp() throws Exception {
        this.conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MAX_KEY, 6);
        this.conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.NONE));
        UTIL.startMiniCluster();
        this.createTable(0, false);
        this.createTable(1, true);
        this.insertedCells = new ArrayList(100);
        for (int r = 0; r < 100; ++r) {
            this.insertedCells.add(new ArrayList(this.qualifiers.length));
            for (int q = 0; q < this.qualifiers.length; ++q) {
                this.insertedCells.get(r).add(new ArrayList(10));
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
        UTIL.cleanupTestDir();
    }

    @Test
    public void testCompactedFiles() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.insertRows(100 * this.maxVersions);
            this.deleteRows(12);
            this.deleteRowVersions(12);
            this.deleteColumns(12);
            this.deleteColumnVersions(12);
            this.flushRegion();
        }
        this.verifyCells();
        HStore[] stores = new HStore[2];
        stores[0] = this.regions[0].getStore(HBaseTestingUtility.fam1);
        Assert.assertEquals((long)this.flushCount, (long)stores[0].getStorefilesCount());
        stores[1] = this.regions[1].getStore(HBaseTestingUtility.fam1);
        Assert.assertEquals((long)this.flushCount, (long)stores[1].getStorefilesCount());
        this.regions[0].compact(false);
        Assert.assertEquals((long)(this.flushCount - stores[0].getCompactedFiles().size() + 1), (long)stores[0].getStorefilesCount());
        this.regions[1].compact(false);
        Assert.assertEquals((long)(this.flushCount - stores[1].getCompactedFiles().size() + 2), (long)stores[1].getStorefilesCount());
        this.verifyCells();
        this.regions[0].compact(true);
        Assert.assertEquals((long)1L, (long)stores[0].getStorefilesCount());
        this.regions[1].compact(true);
        Assert.assertEquals((long)(this.keepDeletedCells == KeepDeletedCells.FALSE ? 1L : 2L), (long)stores[1].getStorefilesCount());
        this.verifyCells();
    }

    private void verifyCells() throws Exception {
        this.scanAndCompare(false);
        this.scanAndCompare(true);
    }

    private void flushRegion() throws Exception {
        this.regions[0].flush(true);
        this.regions[1].flush(true);
        ++this.flushCount;
    }

    private Long getRowTimestamp(int row) {
        Long maxTimestamp = null;
        for (int q = 0; q < this.qualifiers.length; ++q) {
            int size = this.insertedCells.get(row).get(q).size();
            if (size <= 0) continue;
            CellInfo mostRecentCellInfo = this.insertedCells.get(row).get(q).get(size - 1);
            if (mostRecentCellInfo.type != Cell.Type.Put || maxTimestamp != null && maxTimestamp >= mostRecentCellInfo.timestamp) continue;
            maxTimestamp = mostRecentCellInfo.timestamp;
        }
        return maxTimestamp;
    }

    private long getNewTimestamp(long timestamp) throws Exception {
        long newTimestamp = System.currentTimeMillis();
        if (timestamp == newTimestamp) {
            Thread.sleep(1L);
            newTimestamp = System.currentTimeMillis();
            Assert.assertTrue((timestamp < newTimestamp ? 1 : 0) != 0);
        }
        return newTimestamp;
    }

    private void insertRows(int rowCount) throws Exception {
        long timestamp = System.currentTimeMillis();
        for (int r = 0; r < rowCount; ++r) {
            int row = this.RANDOM.nextInt(100);
            Put put = new Put(Bytes.toBytes((String)String.valueOf(row)), timestamp);
            for (int q = 0; q < this.qualifiers.length; ++q) {
                put.addColumn(HBaseTestingUtility.fam1, this.qualifiers[q], Bytes.toBytes((String)String.valueOf(timestamp)));
                this.insertedCells.get(row).get(q).add(new CellInfo(timestamp, Cell.Type.Put));
            }
            this.regions[0].put(put);
            this.regions[1].put(put);
            timestamp = this.getNewTimestamp(timestamp);
        }
    }

    private void deleteRows(int rowCount) throws Exception {
        for (int r = 0; r < rowCount; ++r) {
            long timestamp = System.currentTimeMillis();
            int row = this.RANDOM.nextInt(100);
            Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(row)));
            this.regions[0].delete(delete);
            this.regions[1].delete(delete);
            for (int q = 0; q < this.qualifiers.length; ++q) {
                this.insertedCells.get(row).get(q).add(new CellInfo(timestamp, Cell.Type.DeleteFamily));
            }
        }
    }

    private void deleteSingleRowVersion(int row, long timestamp) throws IOException {
        Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(row)));
        delete.addFamilyVersion(HBaseTestingUtility.fam1, timestamp);
        this.regions[0].delete(delete);
        this.regions[1].delete(delete);
        for (int q = 0; q < this.qualifiers.length; ++q) {
            this.insertedCells.get(row).get(q).add(new CellInfo(timestamp, Cell.Type.DeleteFamilyVersion));
        }
    }

    private void deleteRowVersions(int rowCount) throws Exception {
        int row;
        for (int r = 0; r < rowCount; ++r) {
            row = this.RANDOM.nextInt(100);
            Long timestamp = this.getRowTimestamp(row);
            if (timestamp == null) continue;
            this.deleteSingleRowVersion(row, timestamp);
        }
        row = this.RANDOM.nextInt(100);
        this.deleteSingleRowVersion(row, System.currentTimeMillis());
    }

    private void deleteColumns(int rowCount) throws Exception {
        for (int r = 0; r < rowCount; ++r) {
            long timestamp = System.currentTimeMillis();
            int row = this.RANDOM.nextInt(100);
            int q = this.RANDOM.nextInt(this.qualifiers.length);
            Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(row)), timestamp);
            delete.addColumns(HBaseTestingUtility.fam1, this.qualifiers[q], timestamp);
            this.regions[0].delete(delete);
            this.regions[1].delete(delete);
            this.insertedCells.get(row).get(q).add(new CellInfo(timestamp, Cell.Type.DeleteColumn));
        }
    }

    private void deleteColumnVersions(int rowCount) throws Exception {
        for (int r = 0; r < rowCount; ++r) {
            int row = this.RANDOM.nextInt(100);
            Long timestamp = this.getRowTimestamp(row);
            if (timestamp == null) continue;
            Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(row)));
            int q = this.RANDOM.nextInt(this.qualifiers.length);
            delete.addColumn(HBaseTestingUtility.fam1, this.qualifiers[q], timestamp.longValue());
            this.regions[0].delete(delete);
            this.regions[1].delete(delete);
            this.insertedCells.get(row).get(q).add(new CellInfo(timestamp, Cell.Type.Delete));
        }
    }

    private Scan createScan(boolean raw) {
        Scan scan = new Scan();
        scan.readAllVersions();
        scan.setRaw(raw);
        return scan;
    }

    private void scanAndCompare(boolean raw) throws Exception {
        try (RegionScannerImpl firstRS = this.regions[0].getScanner(this.createScan(raw));
             RegionScannerImpl secondRS = this.regions[1].getScanner(this.createScan(raw));){
            boolean secondHasMore;
            boolean firstHasMore;
            do {
                ArrayList firstRowList = new ArrayList();
                ArrayList secondRowList = new ArrayList();
                firstHasMore = firstRS.nextRaw(firstRowList);
                secondHasMore = secondRS.nextRaw(secondRowList);
                Assert.assertEquals((long)firstRowList.size(), (long)secondRowList.size());
                int size = firstRowList.size();
                for (int i = 0; i < size; ++i) {
                    Cell firstCell = (Cell)firstRowList.get(i);
                    Cell secondCell = (Cell)secondRowList.get(i);
                    Assert.assertTrue((boolean)CellUtil.matchingRowColumn((Cell)firstCell, (Cell)secondCell));
                    Assert.assertTrue((firstCell.getType() == secondCell.getType() ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)firstCell), (byte[])CellUtil.cloneValue((Cell)firstCell)));
                }
            } while (firstHasMore && secondHasMore);
            Assert.assertEquals((Object)firstHasMore, (Object)secondHasMore);
        }
    }

    private static class CellInfo {
        long timestamp;
        Cell.Type type;

        CellInfo(long timestamp, Cell.Type type) {
            this.timestamp = timestamp;
            this.type = type;
        }
    }
}

