/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.security.AbstractTestMutualTls;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestMutualTlsClientSide
extends AbstractTestMutualTls {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutualTlsClientSide.class);

    @Parameterized.Parameters(name="{index}: caKeyType={0}, certKeyType={1}, keyPassword={2}, validateServerHostnames={3}, testCase={4}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (String keyPassword : new String[]{"", "pa$$w0rd"}) {
                    Boolean[] booleanArray = new Boolean[]{true, false};
                    int n = booleanArray.length;
                    for (int i = 0; i < n; ++i) {
                        boolean validateServerHostnames = booleanArray[i];
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, false, validateServerHostnames, AbstractTestMutualTls.CertConfig.NON_VERIFIABLE_CERT});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, !validateServerHostnames, validateServerHostnames, AbstractTestMutualTls.CertConfig.VERIFIABLE_CERT_WITH_BAD_HOST});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateServerHostnames, AbstractTestMutualTls.CertConfig.GOOD_CERT});
                    }
                }
            }
        }
        return params;
    }

    @Override
    protected void initialize(Configuration serverConf, Configuration clientConf) throws IOException, GeneralSecurityException, OperatorCreationException {
        clientConf.setBoolean("hbase.client.netty.tls.verify.server.hostname", this.validateHostnames);
        this.handleCertConfig(serverConf);
    }
}

