/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class VerifyReplicationRecompareRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyReplicationRecompareRunnable.class);
    private final Mapper.Context context;
    private final VerifyReplication.Verifier.Counters originalCounter;
    private final String delimiter;
    private final byte[] row;
    private final Scan tableScan;
    private final Table sourceTable;
    private final Table replicatedTable;
    private final int reCompareTries;
    private final int sleepMsBeforeReCompare;
    private final int reCompareBackoffExponent;
    private final boolean verbose;
    private Result sourceResult;
    private Result replicatedResult;

    public VerifyReplicationRecompareRunnable(Mapper.Context context, Result sourceResult, Result replicatedResult, VerifyReplication.Verifier.Counters originalCounter, String delimiter, Scan tableScan, Table sourceTable, Table replicatedTable, int reCompareTries, int sleepMsBeforeReCompare, int reCompareBackoffExponent, boolean verbose) {
        this.context = context;
        this.sourceResult = sourceResult;
        this.replicatedResult = replicatedResult;
        this.originalCounter = originalCounter;
        this.delimiter = delimiter;
        this.tableScan = tableScan;
        this.sourceTable = sourceTable;
        this.replicatedTable = replicatedTable;
        this.reCompareTries = reCompareTries;
        this.sleepMsBeforeReCompare = sleepMsBeforeReCompare;
        this.reCompareBackoffExponent = reCompareBackoffExponent;
        this.verbose = verbose;
        this.row = VerifyReplication.getRow(sourceResult, replicatedResult);
    }

    @Override
    public void run() {
        Get get = new Get(this.row);
        get.setCacheBlocks(this.tableScan.getCacheBlocks());
        get.setFilter(this.tableScan.getFilter());
        int sleepMs = this.sleepMsBeforeReCompare;
        int tries = 0;
        while (++tries <= this.reCompareTries) {
            block7: {
                this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.RECOMPARES).increment(1L);
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException e) {
                    LOG.warn("Sleeping interrupted, incrementing bad rows and aborting");
                    this.incrementOriginalAndBadCounter();
                    this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.FAILED_RECOMPARE).increment(1L);
                    Thread.currentThread().interrupt();
                    return;
                }
                try {
                    if (this.fetchLatestRows(get) && this.matches(this.sourceResult, this.replicatedResult, null)) {
                        if (this.verbose) {
                            LOG.info("Good row key (with recompare): {}{}{}", new Object[]{this.delimiter, Bytes.toStringBinary((byte[])this.row), this.delimiter});
                        }
                        this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).increment(1L);
                        return;
                    }
                    this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.FAILED_RECOMPARE).increment(1L);
                }
                catch (IOException e) {
                    this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.FAILED_RECOMPARE).increment(1L);
                    if (!this.verbose) break block7;
                    LOG.info("Got an exception during recompare for rowkey={}", (Object)Bytes.toStringBinary((byte[])this.row), (Object)e);
                }
            }
            sleepMs *= 2 ^ this.reCompareBackoffExponent;
        }
        LOG.error("{}, rowkey={}{}{}", new Object[]{this.originalCounter, this.delimiter, Bytes.toStringBinary((byte[])this.row), this.delimiter});
        this.incrementOriginalAndBadCounter();
    }

    public void fail() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called fail on row={}", (Object)Bytes.toStringBinary((byte[])this.row));
        }
        this.incrementOriginalAndBadCounter();
        this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.FAILED_RECOMPARE).increment(1L);
    }

    private boolean fetchLatestRows(Get get) throws IOException {
        Result sourceResult = this.sourceTable.get(get);
        Result replicatedResult = this.replicatedTable.get(get);
        boolean sourceMatches = this.matches(sourceResult, this.sourceResult, VerifyReplication.Verifier.Counters.SOURCE_ROW_CHANGED);
        boolean replicatedMatches = this.matches(replicatedResult, this.replicatedResult, VerifyReplication.Verifier.Counters.PEER_ROW_CHANGED);
        this.sourceResult = sourceResult;
        this.replicatedResult = replicatedResult;
        return sourceMatches && replicatedMatches;
    }

    private boolean matches(Result original, Result updated, VerifyReplication.Verifier.Counters failCounter) {
        try {
            Result.compareResults((Result)original, (Result)updated);
            return true;
        }
        catch (Exception e) {
            if (failCounter != null) {
                this.context.getCounter((Enum)failCounter).increment(1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} for rowkey={}", (Object)failCounter, (Object)Bytes.toStringBinary((byte[])this.row));
                }
            }
            return false;
        }
    }

    private void incrementOriginalAndBadCounter() {
        this.context.getCounter((Enum)this.originalCounter).increment(1L);
        this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).increment(1L);
    }
}

