/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTableResultScanner;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.trace.TableOperationSpanBuilder;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncClientScanner {
    private final Scan scan;
    private final ScanMetrics scanMetrics;
    private final AdvancedScanResultConsumer consumer;
    private final TableName tableName;
    private final AsyncConnectionImpl conn;
    private final Timer retryTimer;
    private final long pauseNs;
    private final long pauseNsForServerOverloaded;
    private final int maxAttempts;
    private final long scanTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final ScanResultCache resultCache;
    private final Span span;
    private final Map<String, byte[]> requestAttributes;
    private final boolean isScanMetricsByRegionEnabled;
    private final AtomicInteger openScannerTries = new AtomicInteger();

    public AsyncClientScanner(Scan scan, AdvancedScanResultConsumer consumer, TableName tableName, AsyncConnectionImpl conn, Timer retryTimer, long pauseNs, long pauseNsForServerOverloaded, int maxAttempts, long scanTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt, Map<String, byte[]> requestAttributes) {
        if (scan.getStartRow() == null) {
            scan.withStartRow(HConstants.EMPTY_START_ROW, scan.includeStartRow());
        }
        if (scan.getStopRow() == null) {
            scan.withStopRow(HConstants.EMPTY_END_ROW, scan.includeStopRow());
        }
        this.scan = scan;
        this.consumer = consumer;
        this.tableName = tableName;
        this.conn = conn;
        this.retryTimer = retryTimer;
        this.pauseNs = pauseNs;
        this.pauseNsForServerOverloaded = pauseNsForServerOverloaded;
        this.maxAttempts = maxAttempts;
        this.scanTimeoutNs = scanTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.resultCache = ConnectionUtils.createScanResultCache(scan);
        this.requestAttributes = requestAttributes;
        boolean isScanMetricsByRegionEnabled = false;
        if (scan.isScanMetricsEnabled()) {
            this.scanMetrics = new ScanMetrics();
            consumer.onScanMetricsCreated(this.scanMetrics);
            if (this.scan.isScanMetricsByRegionEnabled()) {
                isScanMetricsByRegionEnabled = true;
            }
        } else {
            this.scanMetrics = null;
        }
        this.isScanMetricsByRegionEnabled = isScanMetricsByRegionEnabled;
        this.span = new TableOperationSpanBuilder(conn).setTableName(tableName).setOperation(scan).build();
        if (consumer instanceof AsyncTableResultScanner) {
            AsyncTableResultScanner scanner = (AsyncTableResultScanner)consumer;
            scanner.setSpan(this.span);
        }
    }

    private CompletableFuture<OpenScannerResponse> callOpenScanner(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub) {
        try (Scope ignored = this.span.makeCurrent();){
            boolean isRegionServerRemote = ConnectionUtils.isRemote(loc.getHostname());
            ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, isRegionServerRemote);
            if (this.openScannerTries.getAndIncrement() > 1) {
                ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, isRegionServerRemote);
            }
            CompletableFuture<OpenScannerResponse> future = new CompletableFuture<OpenScannerResponse>();
            try {
                ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(loc.getRegion().getRegionName(), this.scan, this.scan.getCaching(), false);
                stub.scan((RpcController)controller, request, resp -> {
                    try (Scope ignored1 = this.span.makeCurrent();){
                        if (controller.failed()) {
                            IOException e = controller.getFailed();
                            future.completeExceptionally(e);
                            TraceUtil.setError((Span)this.span, (Throwable)e);
                            this.span.end();
                            return;
                        }
                        future.complete(new OpenScannerResponse(loc, isRegionServerRemote, stub, controller, (ClientProtos.ScanResponse)resp));
                    }
                });
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
            CompletableFuture<OpenScannerResponse> completableFuture = future;
            return completableFuture;
        }
    }

    private void startScan(OpenScannerResponse resp) {
        FutureUtils.addListener(this.conn.callerFactory.scanSingleRegion().id(resp.resp.getScannerId()).location(resp.loc).remote(resp.isRegionServerRemote).scannerLeaseTimeoutPeriod(resp.resp.getTtl(), TimeUnit.MILLISECONDS).stub(resp.stub).setScan(this.scan).metrics(this.scanMetrics).consumer(this.consumer).resultCache(this.resultCache).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).scanTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForServerOverloaded(this.pauseNsForServerOverloaded, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).setRequestAttributes(this.requestAttributes).start(resp.controller, resp.resp), (hasMore, error) -> {
            Scope ignored = this.span.makeCurrent();
            Throwable throwable = null;
            try {
                if (error != null) {
                    try {
                        this.consumer.onError((Throwable)error);
                        return;
                    }
                    finally {
                        TraceUtil.setError((Span)this.span, (Throwable)error);
                        this.span.end();
                    }
                }
                if (hasMore.booleanValue()) {
                    this.openScanner();
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            try {
                this.consumer.onComplete();
                return;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        });
    }

    private CompletableFuture<OpenScannerResponse> openScanner(int replicaId) {
        try (Scope ignored = this.span.makeCurrent();){
            CompletableFuture<OpenScannerResponse> completableFuture = this.conn.callerFactory.single().table(this.tableName).row(this.scan.getStartRow()).replicaId(replicaId).locateType(ConnectionUtils.getLocateType(this.scan)).priority(this.scan.getPriority()).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForServerOverloaded(this.pauseNsForServerOverloaded, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).setRequestAttributes(this.requestAttributes).action(this::callOpenScanner).call();
            return completableFuture;
        }
    }

    private long getPrimaryTimeoutNs() {
        return TableName.isMetaTableName((TableName)this.tableName) ? this.conn.connConf.getPrimaryMetaScanTimeoutNs() : this.conn.connConf.getPrimaryScanTimeoutNs();
    }

    private void openScanner() {
        if (this.isScanMetricsByRegionEnabled) {
            this.scanMetrics.moveToNextRegion();
        }
        ConnectionUtils.incRegionCountMetrics(this.scanMetrics);
        this.openScannerTries.set(1);
        FutureUtils.addListener(ConnectionUtils.timelineConsistentRead(this.conn.getLocator(), this.tableName, this.scan, this.scan.getStartRow(), ConnectionUtils.getLocateType(this.scan), this::openScanner, this.rpcTimeoutNs, this.getPrimaryTimeoutNs(), this.retryTimer, this.conn.getConnectionMetrics()), (resp, error) -> {
            block19: {
                HRegionLocation loc;
                try (Scope ignored = this.span.makeCurrent();){
                    if (error != null) {
                        try {
                            this.consumer.onError((Throwable)error);
                            return;
                        }
                        finally {
                            TraceUtil.setError((Span)this.span, (Throwable)error);
                            this.span.end();
                        }
                    }
                    if (!this.isScanMetricsByRegionEnabled) break block19;
                    loc = resp.loc;
                }
                this.scanMetrics.initScanMetricsRegionInfo(loc.getRegion().getEncodedName(), loc.getServerName());
            }
            this.startScan((OpenScannerResponse)resp);
        });
    }

    public void start() {
        try (Scope ignored = this.span.makeCurrent();){
            this.openScanner();
        }
    }

    private static final class OpenScannerResponse {
        public final HRegionLocation loc;
        public final boolean isRegionServerRemote;
        public final ClientProtos.ClientService.Interface stub;
        public final HBaseRpcController controller;
        public final ClientProtos.ScanResponse resp;

        public OpenScannerResponse(HRegionLocation loc, boolean isRegionServerRemote, ClientProtos.ClientService.Interface stub, HBaseRpcController controller, ClientProtos.ScanResponse resp) {
            this.loc = loc;
            this.isRegionServerRemote = isRegionServerRemote;
            this.stub = stub;
            this.controller = controller;
            this.resp = resp;
        }
    }
}

