/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ScanMetricsUtil {
    private ScanMetricsUtil() {
    }

    static AtomicLong createCounter(Map<String, AtomicLong> counters, String counterName) {
        AtomicLong c = new AtomicLong(0L);
        counters.put(counterName, c);
        return c;
    }

    static void setCounter(Map<String, AtomicLong> counters, String counterName, long value) {
        AtomicLong c = counters.get(counterName);
        if (c != null) {
            c.set(value);
        }
    }

    static void addToCounter(Map<String, AtomicLong> counters, String counterName, long delta) {
        AtomicLong c = counters.get(counterName);
        if (c != null) {
            c.addAndGet(delta);
        }
    }

    static boolean hasCounter(Map<String, AtomicLong> counters, String counterName) {
        return counters.containsKey(counterName);
    }

    static AtomicLong getCounter(Map<String, AtomicLong> counters, String counterName) {
        return counters.get(counterName);
    }

    static Map<String, Long> collectMetrics(Map<String, AtomicLong> counters, boolean reset) {
        HashMap<String, Long> metricsSnapshot = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> e : counters.entrySet()) {
            long value = reset ? e.getValue().getAndSet(0L) : e.getValue().get();
            metricsSnapshot.put(e.getKey(), value);
        }
        return metricsSnapshot;
    }
}

