/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.SystemExitRule;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HBaseClassTestRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClassTestRule.class);
    public static final Set<Class<?>> UNIT_TEST_CLASSES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Class[]{SmallTests.class, MediumTests.class, LargeTests.class}));
    private static long PER_UNIT_TEST_TIMEOUT_MINS = 13L;
    private final Class<?> clazz;
    private final Timeout timeout;
    private final SystemExitRule systemExitRule = new SystemExitRule();

    private HBaseClassTestRule(Class<?> clazz, Timeout timeout) {
        this.clazz = clazz;
        this.timeout = timeout;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private static long getTimeoutInSeconds(Class<?> clazz) {
        Category[] categories = (Category[])clazz.getAnnotationsByType(Category.class);
        int numParams = HBaseClassTestRule.getNumParameters(clazz);
        if (categories.length == 1) {
            for (Class c : categories[0].value()) {
                if (UNIT_TEST_CLASSES.contains(c)) {
                    long timeout = (long)numParams * PER_UNIT_TEST_TIMEOUT_MINS;
                    LOG.info("Test {} timeout: {} mins", clazz, (Object)timeout);
                    return TimeUnit.MINUTES.toSeconds(timeout);
                }
                if (c != IntegrationTests.class) continue;
                return TimeUnit.MINUTES.toSeconds(Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException(clazz.getName() + " does not have SmallTests/MediumTests/LargeTests in @Category");
    }

    static int getNumParameters(Class<?> clazz) {
        boolean testParameterized;
        RunWith[] runWiths = (RunWith[])clazz.getAnnotationsByType(RunWith.class);
        boolean bl = testParameterized = runWiths != null && Arrays.stream(runWiths).anyMatch(r -> r.value().equals(Parameterized.class));
        if (!testParameterized) {
            return 1;
        }
        for (Method method : clazz.getMethods()) {
            Object parameters;
            if (!HBaseClassTestRule.isParametersMethod(method)) continue;
            try {
                parameters = method.invoke(clazz, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Error invoking parameters method {} in test class {}", new Object[]{method.getName(), clazz, e});
                continue;
            }
            if (parameters instanceof List) {
                return ((List)parameters).size();
            }
            if (parameters instanceof Collection) {
                return ((Collection)parameters).size();
            }
            if (parameters instanceof Iterable) {
                return Iterables.size((Iterable)((Iterable)parameters));
            }
            if (!(parameters instanceof Object[])) continue;
            return ((Object[])parameters).length;
        }
        LOG.warn("Unable to determine parameters size. Returning the default of 1.");
        return 1;
    }

    private static boolean isParametersMethod(@NonNull Method method) {
        boolean methodPublicStatic = Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers());
        Parameterized.Parameters[] params = (Parameterized.Parameters[])method.getAnnotationsByType(Parameterized.Parameters.class);
        return methodPublicStatic && params != null && params.length > 0;
    }

    public static HBaseClassTestRule forClass(Class<?> clazz) {
        return new HBaseClassTestRule(clazz, Timeout.builder().withLookingForStuckThread(true).withTimeout(HBaseClassTestRule.getTimeoutInSeconds(clazz), TimeUnit.SECONDS).build());
    }

    public Statement apply(Statement base, Description description) {
        return this.systemExitRule.apply(this.timeout.apply(base, description), description);
    }
}

