/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Collection;
import java.util.Deque;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CostFromRegionLoadFunction
extends CostFunction {
    private final DoubleArrayCost cost = new DoubleArrayCost();

    CostFromRegionLoadFunction() {
    }

    private double computeCostForRegionServer(int regionServerIndex) {
        double cost = 0.0;
        for (int regionIndex : this.cluster.regionsPerServer[regionServerIndex]) {
            Deque<BalancerRegionLoad> regionLoadList = this.cluster.regionLoads[regionIndex];
            if (regionLoadList == null) continue;
            cost += this.getRegionLoadCost(regionLoadList);
        }
        return cost;
    }

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        this.cost.prepare(cluster.numServers);
        this.cost.applyCostsChange(costs -> {
            for (int i = 0; i < ((double[])costs).length; ++i) {
                costs[i] = this.computeCostForRegionServer(i);
            }
        });
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        this.cost.applyCostsChange(costs -> {
            costs[oldServer] = this.computeCostForRegionServer(oldServer);
            costs[newServer] = this.computeCostForRegionServer(newServer);
        });
    }

    @Override
    protected final double cost() {
        return this.cost.cost();
    }

    protected double getRegionLoadCost(Collection<BalancerRegionLoad> regionLoadList) {
        double cost = 0.0;
        for (BalancerRegionLoad rl : regionLoadList) {
            cost += this.getCostFromRl(rl);
        }
        return cost / (double)regionLoadList.size();
    }

    protected abstract double getCostFromRl(BalancerRegionLoad var1);
}

