/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class PrimaryRegionCountSkewCostFunction
extends CostFunction {
    private static final String PRIMARY_REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.primaryRegionCountCost";
    private static final float DEFAULT_PRIMARY_REGION_COUNT_SKEW_COST = 500.0f;
    private final DoubleArrayCost cost = new DoubleArrayCost();

    PrimaryRegionCountSkewCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(PRIMARY_REGION_COUNT_SKEW_COST_KEY, 500.0f));
    }

    private double computeCostForRegionServer(int regionServerIndex) {
        int cost = 0;
        for (int regionIdx : this.cluster.regionsPerServer[regionServerIndex]) {
            if (regionIdx != this.cluster.regionIndexToPrimaryIndex[regionIdx]) continue;
            ++cost;
        }
        return cost;
    }

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        if (!this.isNeeded()) {
            return;
        }
        this.cost.prepare(cluster.numServers);
        this.cost.applyCostsChange(costs -> {
            for (int i = 0; i < ((double[])costs).length; ++i) {
                costs[i] = this.computeCostForRegionServer(i);
            }
        });
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        this.cost.applyCostsChange(costs -> {
            costs[oldServer] = this.computeCostForRegionServer(oldServer);
            costs[newServer] = this.computeCostForRegionServer(newServer);
        });
    }

    @Override
    boolean isNeeded() {
        return this.cluster.hasRegionReplicas;
    }

    @Override
    protected double cost() {
        return this.cost.cost();
    }
}

