/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class TableSkewCostFunction
extends CostFunction {
    private static final String TABLE_SKEW_COST_KEY = "hbase.master.balancer.stochastic.tableSkewCost";
    private static final float DEFAULT_TABLE_SKEW_COST = 35.0f;
    DoubleArrayCost[] costsPerTable;

    TableSkewCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(TABLE_SKEW_COST_KEY, 35.0f));
    }

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        this.costsPerTable = new DoubleArrayCost[cluster.numTables];
        for (int tableIdx = 0; tableIdx < cluster.numTables; ++tableIdx) {
            this.costsPerTable[tableIdx] = new DoubleArrayCost();
            this.costsPerTable[tableIdx].prepare(cluster.numServers);
            int tableIndex = tableIdx;
            this.costsPerTable[tableIdx].applyCostsChange(costs -> {
                for (int i = 0; i < cluster.numServers; ++i) {
                    costs[i] = cluster.numRegionsPerServerPerTable[tableIndex][i];
                }
            });
        }
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        int tableIdx = this.cluster.regionIndexToTableIndex[region];
        this.costsPerTable[tableIdx].applyCostsChange(costs -> {
            costs[oldServer] = this.cluster.numRegionsPerServerPerTable[tableIdx][oldServer];
            costs[newServer] = this.cluster.numRegionsPerServerPerTable[tableIdx][newServer];
        });
    }

    @Override
    protected double cost() {
        double cost = 0.0;
        for (int tableIdx = 0; tableIdx < this.cluster.numTables; ++tableIdx) {
            cost += this.costsPerTable[tableIdx].cost();
        }
        return cost;
    }
}

