/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSetMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMobStoreFlusher
extends DefaultStoreFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMobStoreFlusher.class);
    private final Object flushLock = new Object();
    private long mobCellValueSizeThreshold = 0L;
    private Path targetPath;
    private HMobStore mobStore;
    static ThreadLocal<Set<String>> mobRefSet = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public DefaultMobStoreFlusher(Configuration conf, HStore store) throws IOException {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobCellValueSizeThreshold = store.getColumnFamilyDescriptor().getMobThreshold();
        this.targetPath = MobUtils.getMobFamilyPath(conf, store.getTableName(), store.getColumnFamilyName());
        if (!this.store.getFileSystem().exists(this.targetPath)) {
            this.store.getFileSystem().mkdirs(this.targetPath);
        }
        this.mobStore = (HMobStore)store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker, Consumer<Path> writerCreationTracker) throws IOException {
        StoreFileWriter writer;
        ArrayList<Path> result = new ArrayList<Path>();
        long cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0L) {
            return result;
        }
        try (InternalScanner scanner = this.createScanner(snapshot.getScanners(), tracker);){
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.createWriter(snapshot, true, writerCreationTracker);
                IOException e = null;
                try {
                    this.performMobFlush(snapshot, cacheFlushId, scanner, writer, status, throughputController, writerCreationTracker);
                }
                catch (IOException ioe) {
                    e = ioe;
                    throw ioe;
                }
                finally {
                    if (e != null) {
                        writer.close();
                    } else {
                        this.finalizeWriter(writer, cacheFlushId, status);
                    }
                }
            }
        }
        LOG.info("Mob store is flushed, sequenceid=" + cacheFlushId + ", memsize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)snapshot.getDataSize(), (String)"", (int)1) + ", hasBloomFilter=" + writer.hasGeneralBloom() + ", into tmp file " + writer.getPath());
        result.add(writer.getPath());
        return result;
    }

    protected void performMobFlush(MemStoreSnapshot snapshot, long cacheFlushId, InternalScanner scanner, StoreFileWriter writer, MonitoredTask status, ThroughputController throughputController, Consumer<Path> writerCreationTracker) throws IOException {
        boolean control;
        StoreFileWriter mobFileWriter = null;
        int compactionKVMax = this.conf.getInt(HConstants.COMPACTION_KV_MAX, 10);
        long mobCount = 0L;
        long mobSize = 0L;
        long time = snapshot.getTimeRangeTracker().getMax();
        mobFileWriter = this.mobStore.getStoreEngine().requireWritingToTmpDirFirst() ? this.mobStore.createWriterInTmp(new Date(time), snapshot.getCellsCount(), this.store.getColumnFamilyDescriptor().getCompressionType(), this.store.getRegionInfo().getStartKey(), false) : this.mobStore.createWriter(new Date(time), snapshot.getCellsCount(), this.store.getColumnFamilyDescriptor().getCompressionType(), this.store.getRegionInfo().getStartKey(), false, writerCreationTracker);
        byte[] fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> cells = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().getTable().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        IOException ioe = null;
        mobRefSet.get().clear();
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (cells.isEmpty()) continue;
                for (Cell c : cells) {
                    if ((long)c.getValueLength() <= this.mobCellValueSizeThreshold || MobUtils.isMobReferenceCell(c) || c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                        writer.append(c);
                    } else {
                        mobFileWriter.append(c);
                        mobSize += (long)c.getValueLength();
                        ++mobCount;
                        Cell reference = MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags());
                        writer.append(reference);
                    }
                    if (!control) continue;
                    throughputController.control(flushName, c.getSerializedSize());
                }
                cells.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            ioe = new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
            throw ioe;
        }
        catch (IOException e) {
            ioe = e;
            throw e;
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
            if (ioe != null) {
                mobFileWriter.close();
            }
        }
        if (mobCount > 0L) {
            status.setStatus("Flushing mob file " + this.store + ": appending metadata");
            mobFileWriter.appendMetadata(cacheFlushId, false, mobCount);
            status.setStatus("Flushing mob file " + this.store + ": closing flushed file");
            mobFileWriter.close();
            this.mobStore.commitFile(mobFileWriter.getPath(), this.targetPath);
            LOG.debug("Flush store file: {}, store: {}", (Object)writer.getPath(), (Object)this.getStoreInfo());
            this.mobStore.updateMobFlushCount();
            this.mobStore.updateMobFlushedCellsCount(mobCount);
            this.mobStore.updateMobFlushedCellsSize(mobSize);
            mobRefSet.get().add(mobFileWriter.getPath().getName());
        } else {
            try {
                status.setStatus("Flushing mob file " + this.store + ": no mob cells, closing flushed file");
                mobFileWriter.close();
                this.store.getFileSystem().delete(mobFileWriter.getPath(), true);
            }
            catch (IOException e) {
                LOG.error("Failed to delete the temp mob file", (Throwable)e);
            }
        }
    }

    @Override
    protected void finalizeWriter(StoreFileWriter writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        writer.appendMobMetadata((SetMultimap<TableName, String>)ImmutableSetMultimap.builder().putAll((Object)this.store.getTableName(), (Iterable)mobRefSet.get()).build());
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    private String getStoreInfo() {
        return String.format("[table=%s family=%s region=%s]", this.store.getTableName().getNameAsString(), this.store.getColumnFamilyName(), this.store.getRegionInfo().getEncodedName());
    }
}

