/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.UserGroupInformation;

public final class HdfsActionUtils {
    public static final String HDFS_USER_CONF_KEY = "org.apache.hadoop.hbase.chaos.actions.hdfs_user";

    private HdfsActionUtils() {
    }

    private static DistributedFileSystem createUnproxiedDfs(Configuration conf) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        return (DistributedFileSystem)fs;
    }

    static DistributedFileSystem createDfs(Configuration conf) throws IOException {
        String proxyUser = conf.get(HDFS_USER_CONF_KEY);
        if (proxyUser == null) {
            return HdfsActionUtils.createUnproxiedDfs(conf);
        }
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
        try {
            return (DistributedFileSystem)proxyUgi.doAs(() -> HdfsActionUtils.createUnproxiedDfs(conf));
        }
        catch (InterruptedException e) {
            InterruptedIOException iioe = new InterruptedIOException(e.getMessage());
            iioe.setStackTrace(e.getStackTrace());
            throw iioe;
        }
    }
}

