/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class OnlineLogRecord
extends LogEntry {
    private static final Gson GSON = GsonUtil.createGson().setPrettyPrinting().registerTypeAdapter((Type)((Object)OnlineLogRecord.class), (slowLogPayload, type, jsonSerializationContext) -> {
        Gson gson = new Gson();
        JsonObject jsonObj = (JsonObject)gson.toJsonTree(slowLogPayload);
        if (slowLogPayload.getMultiGetsCount() == 0) {
            jsonObj.remove("multiGetsCount");
        }
        if (slowLogPayload.getMultiMutationsCount() == 0) {
            jsonObj.remove("multiMutationsCount");
        }
        if (slowLogPayload.getMultiServiceCalls() == 0) {
            jsonObj.remove("multiServiceCalls");
        }
        if (slowLogPayload.getRequestAttributes().isEmpty()) {
            jsonObj.remove("requestAttributes");
        } else {
            jsonObj.add("requestAttributes", gson.toJsonTree(ProtobufUtil.deserializeAttributes(slowLogPayload.getRequestAttributes())));
        }
        if (slowLogPayload.getConnectionAttributes().isEmpty()) {
            jsonObj.remove("connectionAttributes");
        } else {
            jsonObj.add("connectionAttributes", gson.toJsonTree(ProtobufUtil.deserializeAttributes(slowLogPayload.getConnectionAttributes())));
        }
        if (slowLogPayload.getScan().isPresent()) {
            jsonObj.add("scan", gson.toJsonTree(slowLogPayload.getScan().get().toMap()));
        } else {
            jsonObj.remove("scan");
        }
        return jsonObj;
    }).create();
    private final long startTime;
    private final int processingTime;
    private final int queueTime;
    private final long responseSize;
    private final long blockBytesScanned;
    private final long fsReadTime;
    private final String clientAddress;
    private final String serverClass;
    private final String methodName;
    private final String callDetails;
    private final String param;
    private final transient String regionName;
    private final String userName;
    private final int multiGetsCount;
    private final int multiMutationsCount;
    private final int multiServiceCalls;
    private final Optional<Scan> scan;
    private final Map<String, byte[]> requestAttributes;
    private final Map<String, byte[]> connectionAttributes;

    public long getStartTime() {
        return this.startTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getQueueTime() {
        return this.queueTime;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public long getBlockBytesScanned() {
        return this.blockBytesScanned;
    }

    public long getFsReadTime() {
        return this.fsReadTime;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getServerClass() {
        return this.serverClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCallDetails() {
        return this.callDetails;
    }

    public String getParam() {
        return this.param;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getMultiGetsCount() {
        return this.multiGetsCount;
    }

    public int getMultiMutationsCount() {
        return this.multiMutationsCount;
    }

    public int getMultiServiceCalls() {
        return this.multiServiceCalls;
    }

    public Optional<Scan> getScan() {
        return this.scan;
    }

    public Map<String, byte[]> getRequestAttributes() {
        return this.requestAttributes;
    }

    public Map<String, byte[]> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    OnlineLogRecord(long startTime, int processingTime, int queueTime, long responseSize, long blockBytesScanned, long fsReadTime, String clientAddress, String serverClass, String methodName, String callDetails, String param, String regionName, String userName, int multiGetsCount, int multiMutationsCount, int multiServiceCalls, Scan scan, Map<String, byte[]> requestAttributes, Map<String, byte[]> connectionAttributes) {
        this.startTime = startTime;
        this.processingTime = processingTime;
        this.queueTime = queueTime;
        this.responseSize = responseSize;
        this.blockBytesScanned = blockBytesScanned;
        this.fsReadTime = fsReadTime;
        this.clientAddress = clientAddress;
        this.serverClass = serverClass;
        this.methodName = methodName;
        this.callDetails = callDetails;
        this.param = param;
        this.regionName = regionName;
        this.userName = userName;
        this.multiGetsCount = multiGetsCount;
        this.multiMutationsCount = multiMutationsCount;
        this.multiServiceCalls = multiServiceCalls;
        this.scan = Optional.ofNullable(scan);
        this.requestAttributes = requestAttributes;
        this.connectionAttributes = connectionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnlineLogRecord that = (OnlineLogRecord)o;
        return new EqualsBuilder().append(this.startTime, that.startTime).append(this.processingTime, that.processingTime).append(this.queueTime, that.queueTime).append(this.responseSize, that.responseSize).append(this.blockBytesScanned, that.blockBytesScanned).append(this.multiGetsCount, that.multiGetsCount).append(this.multiMutationsCount, that.multiMutationsCount).append(this.multiServiceCalls, that.multiServiceCalls).append(this.clientAddress, that.clientAddress).append(this.serverClass, that.serverClass).append(this.methodName, that.methodName).append(this.callDetails, that.callDetails).append(this.param, that.param).append(this.regionName, that.regionName).append(this.userName, that.userName).append(this.scan, that.scan).append(this.requestAttributes, that.requestAttributes).append(this.connectionAttributes, that.connectionAttributes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.startTime).append(this.processingTime).append(this.queueTime).append(this.responseSize).append(this.blockBytesScanned).append(this.clientAddress).append(this.serverClass).append(this.methodName).append(this.callDetails).append(this.param).append(this.regionName).append(this.userName).append(this.multiGetsCount).append(this.multiMutationsCount).append(this.multiServiceCalls).append(this.scan).append(this.requestAttributes).append(this.connectionAttributes).toHashCode();
    }

    @Override
    public String toJsonPrettyPrint() {
        return GSON.toJson(this);
    }

    public String toString() {
        return new ToStringBuilder(this).append("startTime", this.startTime).append("processingTime", this.processingTime).append("queueTime", this.queueTime).append("responseSize", this.responseSize).append("blockBytesScanned", this.blockBytesScanned).append("clientAddress", this.clientAddress).append("serverClass", this.serverClass).append("methodName", this.methodName).append("callDetails", this.callDetails).append("param", this.param).append("regionName", this.regionName).append("userName", this.userName).append("multiGetsCount", this.multiGetsCount).append("multiMutationsCount", this.multiMutationsCount).append("multiServiceCalls", this.multiServiceCalls).append("scan", this.scan).append("requestAttributes", this.requestAttributes).append("connectionAttributes", this.connectionAttributes).toString();
    }

    public static class OnlineLogRecordBuilder {
        private long startTime;
        private int processingTime;
        private int queueTime;
        private long responseSize;
        private long blockBytesScanned;
        private long fsReadTime;
        private String clientAddress;
        private String serverClass;
        private String methodName;
        private String callDetails;
        private String param;
        private String regionName;
        private String userName;
        private int multiGetsCount;
        private int multiMutationsCount;
        private int multiServiceCalls;
        private Scan scan = null;
        private Map<String, byte[]> requestAttributes;
        private Map<String, byte[]> connectionAttributes;

        public OnlineLogRecordBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public OnlineLogRecordBuilder setProcessingTime(int processingTime) {
            this.processingTime = processingTime;
            return this;
        }

        public OnlineLogRecordBuilder setQueueTime(int queueTime) {
            this.queueTime = queueTime;
            return this;
        }

        public OnlineLogRecordBuilder setResponseSize(long responseSize) {
            this.responseSize = responseSize;
            return this;
        }

        public OnlineLogRecordBuilder setBlockBytesScanned(long blockBytesScanned) {
            this.blockBytesScanned = blockBytesScanned;
            return this;
        }

        public OnlineLogRecordBuilder setFsReadTime(long fsReadTime) {
            this.fsReadTime = fsReadTime;
            return this;
        }

        public OnlineLogRecordBuilder setClientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        public OnlineLogRecordBuilder setServerClass(String serverClass) {
            this.serverClass = serverClass;
            return this;
        }

        public OnlineLogRecordBuilder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public OnlineLogRecordBuilder setCallDetails(String callDetails) {
            this.callDetails = callDetails;
            return this;
        }

        public OnlineLogRecordBuilder setParam(String param) {
            this.param = param;
            return this;
        }

        public OnlineLogRecordBuilder setRegionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public OnlineLogRecordBuilder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public OnlineLogRecordBuilder setMultiGetsCount(int multiGetsCount) {
            this.multiGetsCount = multiGetsCount;
            return this;
        }

        public OnlineLogRecordBuilder setMultiMutationsCount(int multiMutationsCount) {
            this.multiMutationsCount = multiMutationsCount;
            return this;
        }

        public OnlineLogRecordBuilder setMultiServiceCalls(int multiServiceCalls) {
            this.multiServiceCalls = multiServiceCalls;
            return this;
        }

        public OnlineLogRecordBuilder setScan(Scan scan) {
            this.scan = scan;
            return this;
        }

        public OnlineLogRecordBuilder setRequestAttributes(Map<String, byte[]> requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public OnlineLogRecordBuilder setConnectionAttributes(Map<String, byte[]> connectionAttributes) {
            this.connectionAttributes = connectionAttributes;
            return this;
        }

        public OnlineLogRecord build() {
            return new OnlineLogRecord(this.startTime, this.processingTime, this.queueTime, this.responseSize, this.blockBytesScanned, this.fsReadTime, this.clientAddress, this.serverClass, this.methodName, this.callDetails, this.param, this.regionName, this.userName, this.multiGetsCount, this.multiMutationsCount, this.multiServiceCalls, this.scan, this.requestAttributes, this.connectionAttributes);
        }
    }
}

