/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.BooleanStateStore;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionNormalizerProtos;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionNormalizerStateStore
extends BooleanStateStore {
    public static final String STATE_NAME = "region_normalizer_on";

    public RegionNormalizerStateStore(MasterRegion masterRegion, ZKWatcher watcher) throws IOException, KeeperException, DeserializationException {
        super(masterRegion, STATE_NAME, watcher, watcher.getZNodePaths().regionNormalizerZNode);
    }

    @Override
    protected byte[] toByteArray(boolean isNormalizerOn) {
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        builder.setNormalizerOn(isNormalizerOn);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    @Override
    protected boolean parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build().getNormalizerOn();
    }
}

