/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class TableProcedureWaitingQueue {
    private final Function<Long, Procedure<?>> procedureRetriever;
    private Procedure<?> enqueuedProc;
    private final Queue<Procedure<?>> queue = new ArrayDeque();

    TableProcedureWaitingQueue(Function<Long, Procedure<?>> procedureRetriever) {
        this.procedureRetriever = procedureRetriever;
    }

    private boolean isSubProcedure(Procedure<?> proc) {
        while (proc.hasParent()) {
            if (proc.getParentProcId() == this.enqueuedProc.getProcId()) {
                return true;
            }
            proc = Preconditions.checkNotNull(this.procedureRetriever.apply(proc.getParentProcId()), "can not find parent procedure pid=%s", proc.getParentProcId());
        }
        return false;
    }

    boolean procedureSubmitted(Procedure<?> proc) {
        if (this.enqueuedProc == null) {
            this.enqueuedProc = proc;
            return true;
        }
        if (proc == this.enqueuedProc) {
            return true;
        }
        if (this.isSubProcedure(proc)) {
            return true;
        }
        this.queue.add(proc);
        return false;
    }

    Optional<Procedure<?>> procedureCompleted(Procedure<?> proc) {
        Preconditions.checkState(this.enqueuedProc != null, "enqueued procedure should not be null");
        if (this.enqueuedProc == proc) {
            if (!this.queue.isEmpty()) {
                this.enqueuedProc = this.queue.poll();
                return Optional.of(this.enqueuedProc);
            }
            this.enqueuedProc = null;
            return Optional.empty();
        }
        Preconditions.checkState(this.isSubProcedure(proc), "procedure %s is not a sub procedure of enqueued procedure %s", proc, this.enqueuedProc);
        return Optional.empty();
    }

    boolean isEmpty() {
        return this.enqueuedProc == null;
    }

    int waitingSize() {
        return this.queue.size();
    }

    public String toString() {
        return "TableProcedureWaitingQueue [enqueuedProc=" + this.enqueuedProc + ", queue=" + this.queue + "]";
    }
}

