/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExceedOperationQuota
extends DefaultOperationQuota {
    private static final Logger LOG = LoggerFactory.getLogger(ExceedOperationQuota.class);
    private QuotaLimiter regionServerLimiter;

    public ExceedOperationQuota(Configuration conf, int blockSizeBytes, double requestsPerSecond, QuotaLimiter regionServerLimiter, QuotaLimiter ... limiters) {
        super(conf, blockSizeBytes, requestsPerSecond, limiters);
        this.regionServerLimiter = regionServerLimiter;
    }

    @Override
    public void checkBatchQuota(int numWrites, int numReads, boolean isAtomic) throws RpcThrottlingException {
        Runnable estimateQuota = () -> this.updateEstimateConsumeBatchQuota(numWrites, numReads);
        CheckQuotaRunnable checkQuota = () -> super.checkBatchQuota(numWrites, numReads, isAtomic);
        this.checkQuota(estimateQuota, checkQuota, numWrites, numReads, 0, isAtomic);
    }

    @Override
    public void checkScanQuota(ClientProtos.ScanRequest scanRequest, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) throws RpcThrottlingException {
        Runnable estimateQuota = () -> this.updateEstimateConsumeScanQuota(scanRequest, maxScannerResultSize, maxBlockBytesScanned, prevBlockBytesScannedDifference);
        CheckQuotaRunnable checkQuota = () -> super.checkScanQuota(scanRequest, maxScannerResultSize, maxBlockBytesScanned, prevBlockBytesScannedDifference);
        this.checkQuota(estimateQuota, checkQuota, 0, 0, 1, false);
    }

    private void checkQuota(Runnable estimateQuota, CheckQuotaRunnable checkQuota, int numWrites, int numReads, int numScans, boolean isAtomic) throws RpcThrottlingException {
        if (this.regionServerLimiter.isBypass()) {
            LOG.warn("Exceed throttle quota is enabled but no region server quotas found");
            checkQuota.run();
        } else {
            boolean exceed;
            block6: {
                estimateQuota.run();
                this.regionServerLimiter.checkQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed, isAtomic, this.handlerUsageTimeConsumed);
                exceed = false;
                try {
                    checkQuota.run();
                }
                catch (RpcThrottlingException e) {
                    exceed = true;
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Read/Write requests num exceeds quota: writes:{} reads:{}, scans:{}, try use region server quota", new Object[]{numWrites, numReads, numScans});
                }
            }
            this.readAvailable = Math.max(this.readAvailable, this.regionServerLimiter.getReadAvailable());
            this.regionServerLimiter.grabQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.writeCapacityUnitConsumed, isAtomic, this.handlerUsageTimeConsumed);
            if (exceed) {
                for (QuotaLimiter limiter : this.limiters) {
                    limiter.grabQuota(numWrites, this.writeConsumed, numReads + numScans, this.readConsumed, this.writeCapacityUnitConsumed, this.writeCapacityUnitConsumed, isAtomic, 0L);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.writeDiff != 0L) {
            this.regionServerLimiter.consumeWrite(this.writeDiff, this.writeCapacityUnitDiff, false);
        }
        if (this.readDiff != 0L) {
            this.regionServerLimiter.consumeRead(this.readDiff, this.readCapacityUnitDiff, false);
        }
        if (this.handlerUsageTimeDiff != 0L) {
            this.regionServerLimiter.consumeTime(this.handlerUsageTimeDiff);
        }
    }

    private static interface CheckQuotaRunnable {
        public void run() throws RpcThrottlingException;
    }
}

