/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FlushRegionCallable
extends BaseRSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(FlushRegionCallable.class);
    private RegionInfo regionInfo;
    private List<byte[]> columnFamilies;

    @Override
    protected void doCall() throws Exception {
        HRegion region = this.rs.getRegion(this.regionInfo.getEncodedName());
        if (region == null) {
            throw new NotServingRegionException("region=" + this.regionInfo.getRegionNameAsString());
        }
        LOG.debug("Starting region operation on {}", (Object)region);
        region.startRegionOperation();
        try {
            HRegion.FlushResult res = this.columnFamilies == null ? region.flush(true) : region.flushcache(this.columnFamilies, false, FlushLifeCycleTracker.DUMMY);
            if (res.getResult() == HRegion.FlushResult.Result.CANNOT_FLUSH) {
                throw new IOException("Unable to complete flush " + this.regionInfo);
            }
        }
        finally {
            LOG.debug("Closing region operation on {}", (Object)region);
            region.closeRegionOperation();
        }
    }

    @Override
    protected void initParameter(byte[] parameter) throws Exception {
        MasterProcedureProtos.FlushRegionParameter param = MasterProcedureProtos.FlushRegionParameter.parseFrom(parameter);
        this.regionInfo = ProtobufUtil.toRegionInfo(param.getRegion());
        if (param.getColumnFamilyCount() > 0) {
            this.columnFamilies = param.getColumnFamilyList().stream().filter(cf -> !cf.isEmpty()).map(ByteString::toByteArray).collect(Collectors.toList());
        }
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_FLUSH_REGIONS;
    }
}

