/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSSnapshotVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(RSSnapshotVerifier.class);
    private final LoadingCache<SnapshotProtos.SnapshotDescription, Pair<FileSystem, Map<String, SnapshotProtos.SnapshotRegionManifest>>> SNAPSHOT_MANIFEST_CACHE;
    private final Configuration conf;

    public RSSnapshotVerifier(Configuration conf) {
        this.conf = conf;
        long expiredTime = conf.getLong("hbase.snapshot-manifest.cache.expired.sec", 600L);
        long maxSize = conf.getLong("hbase.snapshot-manifest.cache.max.size", 10L);
        this.SNAPSHOT_MANIFEST_CACHE = CacheBuilder.newBuilder().expireAfterAccess(expiredTime, TimeUnit.SECONDS).maximumSize(maxSize).build(new SnapshotManifestCacheLoader(conf));
    }

    public void verifyRegion(final SnapshotProtos.SnapshotDescription snapshot, RegionInfo region) throws IOException {
        try {
            final Pair<FileSystem, Map<String, SnapshotProtos.SnapshotRegionManifest>> cache = this.SNAPSHOT_MANIFEST_CACHE.get(snapshot);
            Map<String, SnapshotProtos.SnapshotRegionManifest> rmMap = cache.getSecond();
            if (rmMap == null) {
                throw new CorruptedSnapshotException(snapshot.getName() + "looks empty");
            }
            SnapshotProtos.SnapshotRegionManifest regionManifest = rmMap.get(region.getEncodedName());
            if (regionManifest == null) {
                LOG.warn("No snapshot region directory found for {}", (Object)region.getRegionNameAsString());
                return;
            }
            RegionInfo manifestRegionInfo = ProtobufUtil.toRegionInfo(regionManifest.getRegionInfo());
            if (RegionInfo.COMPARATOR.compare(region, manifestRegionInfo) != 0) {
                String msg = "Manifest region info " + manifestRegionInfo + "doesn't match expected region:" + region;
                throw new CorruptedSnapshotException(msg, ProtobufUtil.createSnapshotDesc(snapshot));
            }
            SnapshotReferenceUtil.visitRegionStoreFiles(regionManifest, new SnapshotReferenceUtil.StoreFileVisitor(){

                @Override
                public void storeFile(RegionInfo region, String familyName, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                    SnapshotReferenceUtil.verifyStoreFile(RSSnapshotVerifier.this.conf, (FileSystem)cache.getFirst(), null, snapshot, region, familyName, storeFile);
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CorruptedSnapshotException) {
                throw new CorruptedSnapshotException(e.getCause().getMessage(), ProtobufUtil.createSnapshotDesc(snapshot));
            }
            LOG.error("Failed loading snapshot manifest for {} from filesystem", (Object)snapshot.getName(), (Object)e.getCause());
            throw new IOException(e.getCause());
        }
    }

    private static final class SnapshotManifestCacheLoader
    extends CacheLoader<SnapshotProtos.SnapshotDescription, Pair<FileSystem, Map<String, SnapshotProtos.SnapshotRegionManifest>>> {
        private final Configuration conf;

        private SnapshotManifestCacheLoader(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Pair<FileSystem, Map<String, SnapshotProtos.SnapshotRegionManifest>> load(SnapshotProtos.SnapshotDescription snapshot) throws Exception {
            Path rootDir = CommonFSUtils.getRootDir(this.conf);
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, rootDir, this.conf);
            FileSystem rootFs = CommonFSUtils.getRootDirFileSystem(this.conf);
            FileSystem workingDirFS = workingDir.getFileSystem(this.conf);
            SnapshotManifest manifest = SnapshotManifest.open(this.conf, workingDirFS, workingDir, snapshot);
            LOG.debug("loading snapshot manifest for {} from {}", (Object)snapshot.getName(), (Object)workingDir);
            return Pair.newPair(rootFs, manifest.getRegionManifestsMap());
        }
    }
}

