/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DropDeletesCompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MajorCompactionScanQueryMatcher
extends DropDeletesCompactionScanQueryMatcher {
    public MajorCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, ColumnTracker columns, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now) {
        super(scanInfo, deletes, columns, readPointToUse, earliestPutTs, oldestUnexpiredTS, now);
    }

    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long timestamp = cell.getTimestamp();
        long mvccVersion = cell.getSequenceId();
        byte typeByte = cell.getTypeByte();
        if (PrivateCellUtil.isDelete(typeByte)) {
            if (mvccVersion > this.maxReadPointToTrackVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.trackDelete(cell);
            returnCode = this.tryDropDelete(cell);
            if (returnCode != null) {
                return returnCode;
            }
        } else {
            returnCode = this.checkDeleted(this.deletes, cell);
            if (returnCode != null) {
                return returnCode;
            }
        }
        return this.columns.checkVersions(cell, timestamp, typeByte, mvccVersion > this.maxReadPointToTrackVersions);
    }
}

