/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSinkManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSinkManager.class);
    static final int DEFAULT_BAD_SINK_THRESHOLD = 3;
    static final float DEFAULT_REPLICATION_SOURCE_RATIO = 0.5f;
    private final Connection conn;
    private final String peerClusterId;
    private final HBaseReplicationEndpoint endpoint;
    private final Map<ServerName, Integer> badReportCounts;
    private final float ratio;
    private final int badSinkThreshold;
    private final Random random;
    private long lastUpdateToPeers;
    private List<ServerName> sinks = Lists.newArrayList();

    public ReplicationSinkManager(ClusterConnection conn, String peerClusterId, HBaseReplicationEndpoint endpoint, Configuration conf) {
        this.conn = conn;
        this.peerClusterId = peerClusterId;
        this.endpoint = endpoint;
        this.badReportCounts = Maps.newHashMap();
        this.ratio = conf.getFloat("replication.source.ratio", 0.5f);
        this.badSinkThreshold = conf.getInt("replication.bad.sink.threshold", 3);
        this.random = new Random();
    }

    public synchronized SinkPeer getReplicationSink() throws IOException {
        if (this.endpoint.getLastRegionServerUpdate() > this.lastUpdateToPeers || this.sinks.isEmpty()) {
            LOG.info("Current list of sinks is out of date or empty, updating");
            this.chooseSinks();
        }
        if (this.sinks.isEmpty()) {
            throw new IOException("No replication sinks are available");
        }
        ServerName serverName = this.sinks.get(this.random.nextInt(this.sinks.size()));
        return new SinkPeer(serverName, ((ClusterConnection)this.conn).getAdmin(serverName));
    }

    public synchronized void reportBadSink(SinkPeer sinkPeer) {
        ServerName serverName = sinkPeer.getServerName();
        int badReportCount = (this.badReportCounts.containsKey(serverName) ? this.badReportCounts.get(serverName) : 0) + 1;
        this.badReportCounts.put(serverName, badReportCount);
        if (badReportCount > this.badSinkThreshold) {
            this.sinks.remove(serverName);
            if (this.sinks.isEmpty()) {
                this.chooseSinks();
            }
        }
    }

    public synchronized void reportSinkSuccess(SinkPeer sinkPeer) {
        this.badReportCounts.remove(sinkPeer.getServerName());
    }

    public synchronized void chooseSinks() {
        List<ServerName> slaveAddresses = this.endpoint.getRegionServers();
        if (slaveAddresses.isEmpty()) {
            LOG.warn("No sinks available at peer. Will not be able to replicate");
        }
        Collections.shuffle(slaveAddresses, this.random);
        int numSinks = (int)Math.ceil((float)slaveAddresses.size() * this.ratio);
        this.sinks = slaveAddresses.subList(0, numSinks);
        this.lastUpdateToPeers = EnvironmentEdgeManager.currentTime();
        this.badReportCounts.clear();
    }

    public synchronized int getNumSinks() {
        return this.sinks.size();
    }

    protected List<ServerName> getSinksForTesting() {
        return Collections.unmodifiableList(this.sinks);
    }

    public static class SinkPeer {
        private ServerName serverName;
        private AdminProtos.AdminService.BlockingInterface regionServer;

        public SinkPeer(ServerName serverName, AdminProtos.AdminService.BlockingInterface regionServer) {
            this.serverName = serverName;
            this.regionServer = regionServer;
        }

        ServerName getServerName() {
            return this.serverName;
        }

        public AdminProtos.AdminService.BlockingInterface getRegionServer() {
            return this.regionServer;
        }
    }
}

