/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.rest.RestUtil;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.javax.ws.rs.WebApplicationException;
import org.apache.hbase.thirdparty.javax.ws.rs.core.StreamingOutput;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProtobufStreamingOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufStreamingOutput.class);
    private String contentType;
    private ResultScanner resultScanner;
    private int limit;
    private int fetchSize;

    protected ProtobufStreamingOutput(ResultScanner scanner, String type, int limit, int fetchSize) {
        this.resultScanner = scanner;
        this.contentType = type;
        this.limit = limit;
        this.fetchSize = fetchSize;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created StreamingOutput with content type = " + this.contentType + " user limit : " + this.limit + " scan fetch size : " + this.fetchSize);
        }
    }

    public void write(OutputStream outStream) throws IOException, WebApplicationException {
        if (this.limit < this.fetchSize) {
            Result[] rowsToSend = this.resultScanner.next(this.limit);
            this.writeToStream(this.createModelFromResults(rowsToSend), this.contentType, outStream);
        } else {
            Result[] rowsToSend;
            for (int count = this.limit; count > 0 && (rowsToSend = count < this.fetchSize ? this.resultScanner.next(count) : this.resultScanner.next(this.fetchSize)).length != 0; count -= rowsToSend.length) {
                this.writeToStream(this.createModelFromResults(rowsToSend), this.contentType, outStream);
            }
        }
    }

    private void writeToStream(CellSetModel model, String contentType, OutputStream outStream) throws IOException {
        byte[] objectBytes = model.createProtobufOutput();
        outStream.write(Bytes.toBytes((short)((short)objectBytes.length)));
        outStream.write(objectBytes);
        outStream.flush();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Wrote " + model.getRows().size() + " rows to stream successfully.");
        }
    }

    private CellSetModel createModelFromResults(Result[] results) {
        CellSetModel cellSetModel = new CellSetModel();
        for (int i = 0; i < results.length; ++i) {
            if (results[i].isEmpty()) continue;
            cellSetModel.addRow(RestUtil.createRowModelFromResult(results[i]));
        }
        return cellSetModel;
    }
}

