/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemLinkResolver;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputSaslHelper;
import org.apache.hadoop.hbase.io.asyncfs.ProtobufDecoder;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.LocatedBlockHelper;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleState;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateEvent;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FanOutOneBlockAsyncDFSOutputHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FanOutOneBlockAsyncDFSOutputHelper.class);
    public static final String ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES = "hbase.fs.async.create.retries";
    public static final int DEFAULT_ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES = 10;
    private static final ByteBufAllocator ALLOC = PooledByteBufAllocator.DEFAULT;
    public static final long HEART_BEAT_SEQNO = -1L;
    public static final int READ_TIMEOUT = 60000;
    private static final LeaseManager LEASE_MANAGER;
    private static final DFSClientAdaptor DFS_CLIENT_ADAPTOR;
    private static final DummyDFSOutputStreamCreator DUMMY_DFS_OUTPUT_STREAM_CREATOR;
    private static final FileCreator FILE_CREATOR;
    private static final CreateFlag SHOULD_REPLICATE_FLAG;
    private static final String DUMMY_DFS_OUTPUT_STREAM_CLASS = "org.apache.hadoop.hdfs.DummyDFSOutputStream";

    private FanOutOneBlockAsyncDFSOutputHelper() {
    }

    private static DFSClientAdaptor createDFSClientAdaptor() throws NoSuchMethodException {
        final Method isClientRunningMethod = DFSClient.class.getDeclaredMethod("isClientRunning", new Class[0]);
        isClientRunningMethod.setAccessible(true);
        return new DFSClientAdaptor(){

            @Override
            public boolean isClientRunning(DFSClient client) {
                try {
                    return (Boolean)isClientRunningMethod.invoke((Object)client, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static LeaseManager createLeaseManager3_4() throws NoSuchMethodException {
        final Method beginFileLeaseMethod = DFSClient.class.getDeclaredMethod("beginFileLease", String.class, DFSOutputStream.class);
        beginFileLeaseMethod.setAccessible(true);
        final Method endFileLeaseMethod = DFSClient.class.getDeclaredMethod("endFileLease", String.class);
        endFileLeaseMethod.setAccessible(true);
        final Method getUniqKeyMethod = DFSOutputStream.class.getMethod("getUniqKey", new Class[0]);
        return new LeaseManager(){

            private String getUniqKey(FanOutOneBlockAsyncDFSOutput output) throws IllegalAccessException, InvocationTargetException {
                return (String)getUniqKeyMethod.invoke((Object)output.getDummyStream(), new Object[0]);
            }

            @Override
            public void begin(FanOutOneBlockAsyncDFSOutput output) {
                try {
                    beginFileLeaseMethod.invoke((Object)output.getClient(), this.getUniqKey(output), output.getDummyStream());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void end(FanOutOneBlockAsyncDFSOutput output) {
                try {
                    endFileLeaseMethod.invoke((Object)output.getClient(), this.getUniqKey(output));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static LeaseManager createLeaseManager3() throws NoSuchMethodException {
        final Method beginFileLeaseMethod = DFSClient.class.getDeclaredMethod("beginFileLease", Long.TYPE, DFSOutputStream.class);
        beginFileLeaseMethod.setAccessible(true);
        final Method endFileLeaseMethod = DFSClient.class.getDeclaredMethod("endFileLease", Long.TYPE);
        endFileLeaseMethod.setAccessible(true);
        return new LeaseManager(){

            @Override
            public void begin(FanOutOneBlockAsyncDFSOutput output) {
                try {
                    beginFileLeaseMethod.invoke((Object)output.getClient(), output.getStat().getFileId(), output.getDummyStream());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void end(FanOutOneBlockAsyncDFSOutput output) {
                try {
                    endFileLeaseMethod.invoke((Object)output.getClient(), output.getStat().getFileId());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static LeaseManager createLeaseManager() throws NoSuchMethodException {
        try {
            return FanOutOneBlockAsyncDFSOutputHelper.createLeaseManager3_4();
        }
        catch (NoSuchMethodException e) {
            LOG.debug("DFSClient::beginFileLease wrong arguments, should be hadoop 3.3 or below");
            return FanOutOneBlockAsyncDFSOutputHelper.createLeaseManager3();
        }
    }

    private static FileCreator createFileCreator3_3() throws NoSuchMethodException {
        Method createMethod = ClientProtocol.class.getMethod("create", String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class, String.class);
        return (instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions) -> (HdfsFileStatus)createMethod.invoke((Object)instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions, null, null);
    }

    private static FileCreator createFileCreator3() throws NoSuchMethodException {
        Method createMethod = ClientProtocol.class.getMethod("create", String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class);
        return (instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions) -> (HdfsFileStatus)createMethod.invoke((Object)instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions, null);
    }

    private static FileCreator createFileCreator2() throws NoSuchMethodException {
        Method createMethod = ClientProtocol.class.getMethod("create", String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class);
        return (instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions) -> (HdfsFileStatus)createMethod.invoke((Object)instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
    }

    private static FileCreator createFileCreator() throws NoSuchMethodException {
        try {
            return FanOutOneBlockAsyncDFSOutputHelper.createFileCreator3_3();
        }
        catch (NoSuchMethodException e) {
            LOG.debug("ClientProtocol::create wrong number of arguments, should be hadoop 3.2 or below");
            try {
                return FanOutOneBlockAsyncDFSOutputHelper.createFileCreator3();
            }
            catch (NoSuchMethodException e2) {
                LOG.debug("ClientProtocol::create wrong number of arguments, should be hadoop 2.x");
                return FanOutOneBlockAsyncDFSOutputHelper.createFileCreator2();
            }
        }
    }

    private static DummyDFSOutputStreamCreator createDummyDFSOutputStreamCreator() {
        try {
            Constructor<?> constructor = Class.forName(DUMMY_DFS_OUTPUT_STREAM_CLASS).getConstructors()[0];
            return (output, dfsClient, src, stat, flag, checksum) -> {
                try {
                    return (DFSOutputStream)constructor.newInstance(output, dfsClient, src, stat, flag, checksum);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            LOG.debug("can not find DummyDFSOutputStream, should be hadoop 2.x", (Throwable)e);
            return (output, dfsClient, src, stat, flag, checksum) -> null;
        }
    }

    private static CreateFlag loadShouldReplicateFlag() {
        try {
            return CreateFlag.valueOf((String)"SHOULD_REPLICATE");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("can not find SHOULD_REPLICATE flag, should be hadoop 2.x", (Throwable)e);
            return null;
        }
    }

    private static void beginFileLease(FanOutOneBlockAsyncDFSOutput output) {
        LEASE_MANAGER.begin(output);
    }

    static void endFileLease(FanOutOneBlockAsyncDFSOutput output) {
        LEASE_MANAGER.end(output);
    }

    static DataChecksum createChecksum(DFSClient client) {
        return client.getConf().createChecksum(null);
    }

    static DataTransferProtos.Status getStatus(DataTransferProtos.PipelineAckProto ack) {
        Integer headerFlag;
        List flagList = ack.getFlagList();
        if (flagList.isEmpty()) {
            DataTransferProtos.Status reply = ack.getReply(0);
            headerFlag = PipelineAck.combineHeader((PipelineAck.ECN)PipelineAck.ECN.DISABLED, (DataTransferProtos.Status)reply);
        } else {
            headerFlag = (Integer)flagList.get(0);
        }
        return PipelineAck.getStatusFromHeader((int)headerFlag);
    }

    private static void processWriteBlockResponse(Channel channel, final DatanodeInfo dnInfo, final Promise<Channel> promise, final int timeoutMs) {
        channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)timeoutMs, 0L, 0L, TimeUnit.MILLISECONDS), new ProtobufVarint32FrameDecoder(), new ProtobufDecoder(DataTransferProtos.BlockOpResponseProto.getDefaultInstance()), new SimpleChannelInboundHandler<DataTransferProtos.BlockOpResponseProto>(){

            protected void channelRead0(ChannelHandlerContext ctx, DataTransferProtos.BlockOpResponseProto resp) throws Exception {
                ChannelHandler handler;
                DataTransferProtos.Status pipelineStatus = resp.getStatus();
                if (PipelineAck.isRestartOOBStatus((DataTransferProtos.Status)pipelineStatus)) {
                    throw new IOException("datanode " + dnInfo + " is restarting");
                }
                String logInfo = "ack with firstBadLink as " + resp.getFirstBadLink();
                if (resp.getStatus() != DataTransferProtos.Status.SUCCESS) {
                    if (resp.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                        throw new InvalidBlockTokenException("Got access token error, status message " + resp.getMessage() + ", " + logInfo);
                    }
                    throw new IOException("Got error, status=" + resp.getStatus().name() + ", status message " + resp.getMessage() + ", " + logInfo);
                }
                ChannelPipeline p = ctx.pipeline();
                while ((handler = p.removeLast()) != null && !(handler instanceof IdleStateHandler)) {
                }
                ctx.channel().config().setAutoRead(false);
                promise.trySuccess((Object)ctx.channel());
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                promise.tryFailure((Throwable)new IOException("connection to " + dnInfo + " is closed"));
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                    promise.tryFailure((Throwable)new IOException("Timeout(" + timeoutMs + "ms) waiting for response"));
                } else {
                    super.userEventTriggered(ctx, evt);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                promise.tryFailure(cause);
            }
        }});
    }

    private static void requestWriteBlock(Channel channel, StorageType storageType, DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = writeBlockProtoBuilder.setStorageType(PBHelperClient.convertStorageType((StorageType)storageType)).build();
        int protoLen = proto.getSerializedSize();
        ByteBuf buffer = channel.alloc().buffer(3 + CodedOutputStream.computeUInt32SizeNoTag((int)protoLen) + protoLen);
        buffer.writeShort(28);
        buffer.writeByte((int)Op.WRITE_BLOCK.code);
        proto.writeDelimitedTo((OutputStream)new ByteBufOutputStream(buffer));
        NettyFutureUtils.safeWriteAndFlush((ChannelOutboundInvoker)channel, (Object)buffer);
    }

    private static void initialize(Configuration conf, final Channel channel, final DatanodeInfo dnInfo, final StorageType storageType, final DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder, final int timeoutMs, DFSClient client, Token<BlockTokenIdentifier> accessToken, final Promise<Channel> promise) throws IOException {
        Promise saslPromise = channel.eventLoop().newPromise();
        FanOutOneBlockAsyncDFSOutputSaslHelper.trySaslNegotiate(conf, channel, dnInfo, timeoutMs, client, accessToken, (Promise<Void>)saslPromise);
        NettyFutureUtils.addListener((Future)saslPromise, (GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    FanOutOneBlockAsyncDFSOutputHelper.processWriteBlockResponse(channel, dnInfo, (Promise<Channel>)promise, timeoutMs);
                    FanOutOneBlockAsyncDFSOutputHelper.requestWriteBlock(channel, storageType, writeBlockProtoBuilder);
                } else {
                    promise.tryFailure(future.cause());
                }
            }
        });
    }

    private static List<Future<Channel>> connectToDataNodes(final Configuration conf, final DFSClient client, String clientName, final LocatedBlock locatedBlock, long maxBytesRcvd, long latestGS, BlockConstructionStage stage, DataChecksum summer, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        StorageType[] storageTypes = locatedBlock.getStorageTypes();
        DatanodeInfo[] datanodeInfos = LocatedBlockHelper.getLocatedBlockLocations(locatedBlock);
        boolean connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        final int timeoutMs = conf.getInt("dfs.client.socket-timeout", 60000);
        ExtendedBlock blockCopy = new ExtendedBlock(locatedBlock.getBlock());
        blockCopy.setNumBytes(locatedBlock.getBlockSize());
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelperClient.convert((ExtendedBlock)blockCopy)).setToken(PBHelperClient.convert((Token)locatedBlock.getBlockToken()))).setClientName(clientName).build();
        DataTransferProtos.ChecksumProto checksumProto = DataTransferProtoUtil.toProto((DataChecksum)summer);
        final DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder = DataTransferProtos.OpWriteBlockProto.newBuilder().setHeader(header).setStage(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf((String)stage.name())).setPipelineSize(1).setMinBytesRcvd(locatedBlock.getBlock().getNumBytes()).setMaxBytesRcvd(maxBytesRcvd).setLatestGenerationStamp(latestGS).setRequestedChecksum(checksumProto).setCachingStrategy(DataTransferProtos.CachingStrategyProto.newBuilder().setDropBehind(true).build());
        ArrayList<Future<Channel>> futureList = new ArrayList<Future<Channel>>(datanodeInfos.length);
        for (int i = 0; i < datanodeInfos.length; ++i) {
            final DatanodeInfo dnInfo = datanodeInfos[i];
            final StorageType storageType = storageTypes[i];
            final Promise promise = eventLoopGroup.next().newPromise();
            futureList.add((Future<Channel>)promise);
            String dnAddr = dnInfo.getXferAddr(connectToDnViaHostname);
            NettyFutureUtils.addListener((Future)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(channelClass)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMs)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                }
            })).connect((SocketAddress)NetUtils.createSocketAddr((String)dnAddr)), (GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        FanOutOneBlockAsyncDFSOutputHelper.initialize(conf, future.channel(), dnInfo, storageType, writeBlockProtoBuilder, timeoutMs, client, (Token<BlockTokenIdentifier>)locatedBlock.getBlockToken(), (Promise<Channel>)promise);
                    } else {
                        promise.tryFailure(future.cause());
                    }
                }
            });
        }
        return futureList;
    }

    private static EnumSetWritable<CreateFlag> getCreateFlags(boolean overwrite, boolean noLocalWrite) {
        ArrayList<CreateFlag> flags = new ArrayList<CreateFlag>();
        flags.add(CreateFlag.CREATE);
        if (overwrite) {
            flags.add(CreateFlag.OVERWRITE);
        }
        if (SHOULD_REPLICATE_FLAG != null) {
            flags.add(SHOULD_REPLICATE_FLAG);
        }
        if (noLocalWrite) {
            flags.add(CreateFlag.NO_LOCAL_WRITE);
        }
        return new EnumSetWritable(EnumSet.copyOf(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private static FanOutOneBlockAsyncDFSOutput createOutput(DistributedFileSystem dfs, String src, boolean overwrite, boolean createParent, short replication, long blockSize, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, StreamSlowMonitor monitor, boolean noLocalWrite) throws IOException {
        Configuration conf = dfs.getConf();
        DFSClient client = dfs.getClient();
        String clientName = client.getClientName();
        ClientProtocol namenode = client.getNamenode();
        int createMaxRetries = conf.getInt(ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES, 10);
        ExcludeDatanodeManager excludeDatanodeManager = monitor.getExcludeDatanodeManager();
        HashSet<DatanodeInfo> toExcludeNodes = new HashSet<DatanodeInfo>(excludeDatanodeManager.getExcludeDNs().keySet());
        int retry = 0;
        while (true) {
            block26: {
                FanOutOneBlockAsyncDFSOutput fanOutOneBlockAsyncDFSOutput;
                List<Future<Channel>> futureList;
                boolean succ;
                block25: {
                    HdfsFileStatus stat;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("When create output stream for {}, exclude list is {}, retry={}", new Object[]{src, FanOutOneBlockAsyncDFSOutputHelper.getDataNodeInfo(toExcludeNodes), retry});
                    }
                    EnumSetWritable<CreateFlag> createFlags = FanOutOneBlockAsyncDFSOutputHelper.getCreateFlags(overwrite, noLocalWrite);
                    try {
                        stat = FILE_CREATOR.create(namenode, src, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), clientName, createFlags, createParent, replication, blockSize, CryptoProtocolVersion.supported());
                    }
                    catch (Exception e) {
                        if (e instanceof RemoteException) {
                            throw (RemoteException)((Object)e);
                        }
                        throw new NameNodeException(e);
                    }
                    succ = false;
                    LocatedBlock locatedBlock = null;
                    futureList = null;
                    try {
                        DataChecksum summer = FanOutOneBlockAsyncDFSOutputHelper.createChecksum(client);
                        locatedBlock = namenode.addBlock(src, client.getClientName(), null, toExcludeNodes.toArray(new DatanodeInfo[0]), stat.getFileId(), null, null);
                        IdentityHashMap<Channel, DatanodeInfo> datanodes = new IdentityHashMap<Channel, DatanodeInfo>();
                        futureList = FanOutOneBlockAsyncDFSOutputHelper.connectToDataNodes(conf, client, clientName, locatedBlock, 0L, 0L, BlockConstructionStage.PIPELINE_SETUP_CREATE, summer, eventLoopGroup, channelClass);
                        int n = futureList.size();
                        for (int i = 0; i < n; ++i) {
                            DatanodeInfo datanodeInfo = LocatedBlockHelper.getLocatedBlockLocations(locatedBlock)[i];
                            try {
                                datanodes.put((Channel)futureList.get(i).syncUninterruptibly().getNow(), datanodeInfo);
                                continue;
                            }
                            catch (Exception e) {
                                toExcludeNodes.add(datanodeInfo);
                                excludeDatanodeManager.tryAddExcludeDN(datanodeInfo, "connect error");
                                throw e;
                            }
                        }
                        Encryptor encryptor = FanOutOneBlockAsyncDFSOutputSaslHelper.createEncryptor(conf, stat, client);
                        FanOutOneBlockAsyncDFSOutput output = new FanOutOneBlockAsyncDFSOutput(conf, dfs, client, namenode, clientName, src, stat, createFlags.get(), locatedBlock, encryptor, datanodes, summer, ALLOC, monitor);
                        FanOutOneBlockAsyncDFSOutputHelper.beginFileLease(output);
                        succ = true;
                        fanOutOneBlockAsyncDFSOutput = output;
                        if (succ || futureList == null) break block25;
                    }
                    catch (RemoteException e) {
                        LOG.warn("create fan-out dfs output {} failed, retry = {}", new Object[]{src, retry, e});
                        if (FanOutOneBlockAsyncDFSOutputHelper.shouldRetryCreate(e)) {
                            if (retry >= createMaxRetries) {
                                throw e.unwrapRemoteException();
                            }
                        } else {
                            throw e.unwrapRemoteException();
                        }
                        if (succ || futureList == null) break block26;
                        for (Future<Channel> f : futureList) {
                            NettyFutureUtils.addListener((Future)f, (GenericFutureListener)new FutureListener<Channel>(){

                                public void operationComplete(Future<Channel> future) throws Exception {
                                    if (future.isSuccess()) {
                                        NettyFutureUtils.safeClose((ChannelOutboundInvoker)((ChannelOutboundInvoker)future.getNow()));
                                    }
                                }
                            });
                        }
                    }
                    for (Future<Channel> f : futureList) {
                        NettyFutureUtils.addListener(f, (GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
                    }
                }
                return fanOutOneBlockAsyncDFSOutput;
                break block26;
                catch (IOException e2) {
                    LOG.warn("create fan-out dfs output {} failed, retry = {}", new Object[]{src, retry, e2});
                    if (retry >= createMaxRetries) {
                        throw e2;
                    }
                    overwrite = true;
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime((long)100L, (int)retry));
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException();
                    }
                    if (succ || futureList == null) break block26;
                    for (Future<Channel> f : futureList) {
                        NettyFutureUtils.addListener(f, (GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
                    }
                    {
                        catch (Throwable throwable) {
                            if (!succ && futureList != null) {
                                for (Future f : futureList) {
                                    NettyFutureUtils.addListener((Future)f, (GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
            }
            ++retry;
        }
    }

    public static FanOutOneBlockAsyncDFSOutput createOutput(final DistributedFileSystem dfs, Path f, final boolean overwrite, final boolean createParent, final short replication, final long blockSize, final EventLoopGroup eventLoopGroup, final Class<? extends Channel> channelClass, final StreamSlowMonitor monitor, final boolean noLocalWrite) throws IOException {
        return (FanOutOneBlockAsyncDFSOutput)new FileSystemLinkResolver<FanOutOneBlockAsyncDFSOutput>(){

            public FanOutOneBlockAsyncDFSOutput doCall(Path p) throws IOException, UnresolvedLinkException {
                return FanOutOneBlockAsyncDFSOutputHelper.createOutput(dfs, p.toUri().getPath(), overwrite, createParent, replication, blockSize, eventLoopGroup, (Class<? extends Channel>)channelClass, monitor, noLocalWrite);
            }

            public FanOutOneBlockAsyncDFSOutput next(FileSystem fs, Path p) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.resolve((FileSystem)dfs, f);
    }

    public static boolean shouldRetryCreate(RemoteException e) {
        return e.getClassName().endsWith("RetryStartFileException");
    }

    static void completeFile(FanOutOneBlockAsyncDFSOutput output, DFSClient client, ClientProtocol namenode, String src, String clientName, ExtendedBlock block, HdfsFileStatus stat) throws IOException {
        int maxRetries = client.getConf().getNumBlockWriteLocateFollowingRetry();
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                if (namenode.complete(src, clientName, block, stat.getFileId())) {
                    FanOutOneBlockAsyncDFSOutputHelper.endFileLease(output);
                    return;
                }
                LOG.warn("complete file " + src + " not finished, retry = " + retry);
            }
            catch (RemoteException e) {
                throw e.unwrapRemoteException();
            }
            FanOutOneBlockAsyncDFSOutputHelper.sleepIgnoreInterrupt(retry);
        }
        throw new IOException("can not complete file after retrying " + maxRetries + " times");
    }

    static void sleepIgnoreInterrupt(int retry) {
        try {
            Thread.sleep(ConnectionUtils.getPauseTime((long)100L, (int)retry));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getDataNodeInfo(Collection<DatanodeInfo> datanodeInfos) {
        if (datanodeInfos.isEmpty()) {
            return "[]";
        }
        return datanodeInfos.stream().map(datanodeInfo -> "(" + datanodeInfo.getHostName() + "/" + datanodeInfo.getInfoAddr() + ":" + datanodeInfo.getInfoPort() + ")").collect(Collectors.joining(",", "[", "]"));
    }

    static DFSOutputStream createDummyDFSOutputStream(AsyncFSOutput output, DFSClient dfsClient, String src, HdfsFileStatus stat, EnumSet<CreateFlag> flag, DataChecksum checksum) {
        return DUMMY_DFS_OUTPUT_STREAM_CREATOR.createDummyDFSOutputStream(output, dfsClient, src, stat, flag, checksum);
    }

    static {
        DUMMY_DFS_OUTPUT_STREAM_CREATOR = FanOutOneBlockAsyncDFSOutputHelper.createDummyDFSOutputStreamCreator();
        try {
            LEASE_MANAGER = FanOutOneBlockAsyncDFSOutputHelper.createLeaseManager();
            DFS_CLIENT_ADAPTOR = FanOutOneBlockAsyncDFSOutputHelper.createDFSClientAdaptor();
            FILE_CREATOR = FanOutOneBlockAsyncDFSOutputHelper.createFileCreator();
            SHOULD_REPLICATE_FLAG = FanOutOneBlockAsyncDFSOutputHelper.loadShouldReplicateFlag();
        }
        catch (Exception e) {
            String msg = "Couldn't properly initialize access to HDFS internals. Please update your WAL Provider to not make use of the 'asyncfs' provider. See HBASE-16110 for more information.";
            LOG.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    public static class NameNodeException
    extends IOException {
        private static final long serialVersionUID = 3143237406477095390L;

        public NameNodeException(Throwable cause) {
            super(cause);
        }
    }

    static final class CancelOnClose
    implements CancelableProgressable {
        private final DFSClient client;

        public CancelOnClose(DFSClient client) {
            this.client = client;
        }

        @Override
        public boolean progress() {
            return DFS_CLIENT_ADAPTOR.isClientRunning(this.client);
        }
    }

    private static interface DummyDFSOutputStreamCreator {
        public DFSOutputStream createDummyDFSOutputStream(AsyncFSOutput var1, DFSClient var2, String var3, HdfsFileStatus var4, EnumSet<CreateFlag> var5, DataChecksum var6);
    }

    private static interface FileCreator {
        default public HdfsFileStatus create(ClientProtocol instance, String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws Exception {
            try {
                return (HdfsFileStatus)this.createObject(instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        public Object createObject(ClientProtocol var1, String var2, FsPermission var3, String var4, EnumSetWritable<CreateFlag> var5, boolean var6, short var7, long var8, CryptoProtocolVersion[] var10) throws Exception;
    }

    private static interface DFSClientAdaptor {
        public boolean isClientRunning(DFSClient var1);
    }

    private static interface LeaseManager {
        public void begin(FanOutOneBlockAsyncDFSOutput var1);

        public void end(FanOutOneBlockAsyncDFSOutput var1);
    }
}

