/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.mode;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenView;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ModeScreenPresenter {
    private final ModeScreenView modeScreenView;
    private final Mode currentMode;
    private final Consumer<Mode> resultListener;
    private final ScreenView nextScreenView;
    private final int modeHeaderMaxLength;
    private final int modeDescriptionMaxLength;
    private final List<Mode> modes = Arrays.asList(Mode.values());
    private int currentPosition;

    public ModeScreenPresenter(ModeScreenView modeScreenView, Mode currentMode, Consumer<Mode> resultListener, ScreenView nextScreenView) {
        this.modeScreenView = Objects.requireNonNull(modeScreenView);
        this.currentMode = Objects.requireNonNull(currentMode);
        this.resultListener = Objects.requireNonNull(resultListener);
        this.nextScreenView = Objects.requireNonNull(nextScreenView);
        int modeHeaderLength = 0;
        int modeDescriptionLength = 0;
        for (int i = 0; i < this.modes.size(); ++i) {
            Mode mode = this.modes.get(i);
            if (mode == currentMode) {
                this.currentPosition = i;
            }
            if (modeHeaderLength < mode.getHeader().length()) {
                modeHeaderLength = mode.getHeader().length();
            }
            if (modeDescriptionLength >= mode.getDescription().length()) continue;
            modeDescriptionLength = mode.getDescription().length();
        }
        this.modeHeaderMaxLength = modeHeaderLength;
        this.modeDescriptionMaxLength = modeDescriptionLength;
    }

    public void init() {
        this.modeScreenView.hideCursor();
        this.modeScreenView.clearTerminal();
        this.modeScreenView.showModeScreen(this.currentMode, this.modes, this.currentPosition, this.modeHeaderMaxLength, this.modeDescriptionMaxLength);
        this.modeScreenView.refreshTerminal();
    }

    public void arrowUp() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            this.showMode(this.currentPosition);
            this.showMode(this.currentPosition + 1);
            this.modeScreenView.refreshTerminal();
        }
    }

    public void arrowDown() {
        if (this.currentPosition < this.modes.size() - 1) {
            ++this.currentPosition;
            this.showMode(this.currentPosition);
            this.showMode(this.currentPosition - 1);
            this.modeScreenView.refreshTerminal();
        }
    }

    public void pageUp() {
        if (this.currentPosition > 0) {
            int previousPosition = this.currentPosition;
            this.currentPosition = 0;
            this.showMode(previousPosition);
            this.showMode(this.currentPosition);
            this.modeScreenView.refreshTerminal();
        }
    }

    public void pageDown() {
        if (this.currentPosition < this.modes.size() - 1) {
            int previousPosition = this.currentPosition;
            this.currentPosition = this.modes.size() - 1;
            this.showMode(previousPosition);
            this.showMode(this.currentPosition);
            this.modeScreenView.refreshTerminal();
        }
    }

    private void showMode(int pos) {
        this.modeScreenView.showMode(pos, this.modes.get(pos), pos == this.currentPosition, this.modeHeaderMaxLength, this.modeDescriptionMaxLength);
    }

    public ScreenView transitionToNextScreen(boolean changeMode) {
        Mode selectedMode = this.modes.get(this.currentPosition);
        if (changeMode && this.currentMode != selectedMode) {
            this.resultListener.accept(selectedMode);
        }
        return this.nextScreenView;
    }
}

